% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/wfs_cp.R
\name{catr_wfs_get_parcels_bbox}
\alias{catr_wfs_get_parcels_bbox}
\alias{catr_wfs_get_parcels_zoning}
\alias{catr_wfs_get_parcels_parcel}
\alias{catr_wfs_get_parcels_neigh_parcel}
\alias{catr_wfs_get_parcels_parcel_zoning}
\title{WFS INSPIRE: Download Cadastral Parcels}
\usage{
catr_wfs_get_parcels_bbox(x, what = "parcel", srs, verbose = FALSE)

catr_wfs_get_parcels_zoning(cod_zona, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_parcel(rc, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_neigh_parcel(rc, srs = NULL, verbose = FALSE)

catr_wfs_get_parcels_parcel_zoning(cod_zona, srs = NULL, verbose = FALSE)
}
\arguments{
\item{x}{See \strong{Details}. It could be:
\itemize{
\item A numeric vector of length 4 with the coordinates that defines
the bounding box: \code{c(xmin, ymin, xmax, ymax)}
\item A \code{sf/sfc} object, as provided by the \strong{sf} package.
}}

\item{what}{Information to load. It could be \code{"parcel"} for cadastral parcels
or \code{"zoning"} for cadastral zoning.}

\item{srs}{SRS/CRS to use on the query. To check the admitted values check
\link{catr_srs_values}, specifically the \code{wfs_service} column. See \strong{Details}.}

\item{verbose}{Logical, displays information. Useful for debugging,
default is \code{FALSE}.}

\item{cod_zona}{Cadastral zone code.}

\item{rc}{The cadastral reference to be extracted.}
}
\value{
A \code{sf} object.
}
\description{
Get the spatial data of cadastral parcels and zones. The WFS Service allows
to perform several types of queries:
\itemize{
\item By bounding box: Implemented on \code{catr_wfs_get_parcels_bbox()}. Extract objects
included on the bounding box provided. See \strong{Details}.
}

\itemize{
\item By zoning: Implemented on \code{catr_wfs_get_parcels_zoning()}. Extract
objects of a specific cadastral zone.
}

\itemize{
\item By cadastral parcel: Implemented on \code{catr_wfs_get_parcels_parcel()}. Extract
cadastral parcels of a specific cadastral reference.
}

\itemize{
\item Neighbor cadastral parcels: Implemented on \code{catr_wfs_get_parcels_neigh_parcel()}.
Extract neighbor cadastral parcels of a specific cadastral reference.
}

\itemize{
\item Cadastral parcels by zoning: Implemented on \code{catr_wfs_get_parcels_parcel_zoning()}.
Extract cadastral parcels of a specific cadastral zone.
}

Check the
\href{https://www.catastro.minhap.es/webinspire/documentos/inspire-cp-WFS.pdf}{API Docs}.
}
\details{
When \code{x} is a numeric vector, make sure that the \code{srs} matches the
coordinate values. Additionally, when the \code{srs} correspond to a geographic
reference system (4326, 4258), the function queries the bounding box on
\href{https://epsg.io/3857}{EPSG:3857} - Web Mercator, to overcome
a potential bug on the API side. The result is provided always in the SRS
provided in \code{srs}.

When \code{x} is a \code{sf} object, the value \code{srs} is ignored. The query is
performed using \href{https://epsg.io/3857}{EPSG:3857} (Web Mercator) and the
spatial object is projected back to the SRS of the initial object.
}
\section{API Limits}{
The API service is limited to the following constrains:
\itemize{
\item \verb{"parcel}: Bounding box of 1km2 and a maximum of 500. elements.
\item \code{"zoning"}: Bounding box of 25km2 and a maximum of 500 elements.
}
}

\examples{
\dontshow{if (tolower(Sys.info()[["sysname"]]) != "linux") (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
cp <- catr_wfs_get_parcels_bbox(c(
  233673, 4015968, 233761, 4016008
),
srs = 25830
)

library(ggplot2)

ggplot(cp) +
  geom_sf()
}
\dontshow{\}) # examplesIf}
}
\references{
\href{https://www.catastro.minhap.es/webinspire/documentos/inspire-cp-WFS.pdf}{API Documentation}

\href{https://www.catastro.minhap.es/webinspire/index.html}{INSPIRE Services for Cadastral Cartography}
}
\seealso{
\code{\link[sf:st_bbox]{sf::st_bbox()}}

INSPIRE API functions:
\code{\link{catr_atom_get_address_db_all}()},
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings_db_all}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wms_get_layer}()}

Other INSPIRE WFS services:
\code{\link{catr_srs_values}},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()}

Other parcels: 
\code{\link{catr_atom_get_parcels_db_all}()},
\code{\link{catr_atom_get_parcels}()}

Other spatial: 
\code{\link{catr_atom_get_address}()},
\code{\link{catr_atom_get_buildings}()},
\code{\link{catr_atom_get_parcels}()},
\code{\link{catr_wfs_get_address_bbox}()},
\code{\link{catr_wfs_get_buildings_bbox}()},
\code{\link{catr_wms_get_layer}()}
}
\concept{INSPIRE}
\concept{WFS}
\concept{parcels}
\concept{spatial}
