% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CauchyCP.R
\name{CauchyCP}
\alias{CauchyCP}
\title{A robust test under non-proportional hazards using Cauchy combination of change-point Cox regressions.}
\usage{
CauchyCP(time, status, x, covar = rep(1, length(time)),
  cutpoints = c(0, quantile(time[status == 1])[2:4]))
}
\arguments{
\item{time}{- Follow up time for right censored data.}

\item{status}{- The event status indicator, 0=censored, 1=event.}

\item{x}{- The variable of interest, e.g. a treatment indicator.}

\item{covar}{- The matrix of covariates. If no covariates, a vector of ones should be used (default).}

\item{cutpoints}{- The pre-specified change-points. The default choice is a vector of 0th, 25th, 50th and 75th percentiles of the event time.}
}
\value{
1. A matrix of estimated hazard ratios before and after the change-points. 2. the vector of p-values corresponding to the change-points. 3. a final p-value.
}
\description{
A robust test under non-proportional hazards using Cauchy combination of change-point Cox regressions.
}
\examples{
data(gast)
CauchyCP(time=gast$time, status=gast$status, x=gast$trt)
}
\references{
Hong Zhang, Qing Li, Devan Mehrotra and Judong Shen. "CauchyCP: a powerful test under non-proportional hazards using Cauchy combination of change-point Cox regressions", arXiv:2101.00059.
}
