% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generate_synthetic_data.R
\name{generate_syn_data}
\alias{generate_syn_data}
\title{Generate synthetic data for the CausalGPS package}
\usage{
generate_syn_data(
  sample_size = 1000,
  outcome_sd = 10,
  gps_spec = 1,
  cova_spec = 1
)
}
\arguments{
\item{sample_size}{Number of data samples.}

\item{outcome_sd}{Standard deviation used to generate the outcome in the
synthetic data set.}

\item{gps_spec}{A numerical value (1-7) that indicates the GPS model
used to generate synthetic data. See the code for more details.}

\item{cova_spec}{A numerical value (1-2) to modify the covariates. See the
code for more details.}
}
\value{
\code{synthetic_data}: The function returns a data.frame saved the
constructed synthetic data.
}
\description{
Generates synthetic data set based on different GPS models and covariates.
}
\examples{

set.seed(298)
s_data <- generate_syn_data(sample_size=100,
                                  outcome_sd = 10, gps_spec = 1,
                                  cova_spec = 1)

}
