% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/estimate_npmetric_erf.R
\name{estimate_npmetric_erf}
\alias{estimate_npmetric_erf}
\title{Estimate smoothed exposure-response function (ERF) for pseudo population}
\usage{
estimate_npmetric_erf(
  m_Y,
  m_w,
  counter_weight,
  bw_seq = seq(0.2, 2, 0.2),
  w_vals,
  nthread
)
}
\arguments{
\item{m_Y}{A vector of outcome variable in the matched set.}

\item{m_w}{A vector of continuous exposure variable in the matched set.}

\item{counter_weight}{A vector of counter or weight variable in the matched
set.}

\item{bw_seq}{A vector of bandwidth values (Default is seq(0.2,2,0.2)).}

\item{w_vals}{A vector of values that you want to calculate the values of
the ERF at.}

\item{nthread}{The number of available cores.}
}
\value{
The function returns a gpsm_erf object. The object includes the following
attributes:
\itemize{
\item params
\item m_Y
\item m_w
\item bw_seq
\item w_vals
\item erf
\item fcall
}
}
\description{
Estimate smoothed exposure-response function (ERF) for matched and weighted
data set using non-parametric models.
}
\details{
Estimate Functions Using Local Polynomial kernel regression.
}
\examples{

set.seed(697)
m_d <- generate_syn_data(sample_size = 200)
pseudo_pop <- generate_pseudo_pop(m_d$Y,
                                  m_d$treat,
                                  m_d[c("cf1","cf2","cf3",
                                        "cf4","cf5","cf6")],
                                  ci_appr = "matching",
                                  pred_model = "sl",
                                  sl_lib = c("m_xgboost"),
                                  params = list(xgb_nrounds=c(10,20,30),
                                   xgb_eta=c(0.1,0.2,0.3)),
                                  nthread = 1,
                                  covar_bl_method = "absolute",
                                  covar_bl_trs = 0.1,
                                  covar_bl_trs_type="mean",
                                  max_attempt = 1,
                                  matching_fun = "matching_l1",
                                  delta_n = 1,
                                  scale = 0.5)

erf_obj <- estimate_npmetric_erf(pseudo_pop$pseudo_pop$Y,
                                 pseudo_pop$pseudo_pop$w,
                                 pseudo_pop$pseudo_pop$counter_weight,
                                 bw_seq=seq(0.2,2,0.2),
                                 w_vals = seq(2,20,0.5),
                                 nthread = 1)

}
