% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/CausalKinetiX.modelranking.R
\name{CausalKinetiX.modelranking}
\alias{CausalKinetiX.modelranking}
\title{CausalKinetix.modelranking}
\usage{
CausalKinetiX.modelranking(D, times, env, target, models, pars = list())
}
\arguments{
\item{D}{data matrix. Should have dimension n x (L*d), where n is
the number of repetitions (over all experiments), L is the
number of time points and d is the number of predictor
variables.}

\item{times}{vector of length L specifying the time points at
which data was observed.}

\item{env}{integer vector of length n encoding to which experiment
each repetition belongs.}

\item{target}{integer specifing which variable is the target.}

\item{models}{list of models. Each model is specified by a list of
vectors specifiying the variables included in the interactions
of each term.}

\item{pars}{list of the following parameters: \code{pen.degree}
(default 2) specifies the penalization degree in the smoothing
spline, \code{num.folds} (default 2) number of folds used in
cross-validation of smoothing spline, \code{include.vars}
(default NA) specifies variables that should be included in each
model, \code{include.intercept} (default FALSE) specifies
whether to include a intercept in models, \code{average.reps}
(default FALSE) specifies whether to average repetitions in each
environment, \code{smooth.X} (default FALSE) specifies whether
to smooth predictor observations before fitting, \code{smooth.Y}
(default FALSE) specifies whether to smooth target observations
before fitting, \code{regression.class} (default OLS) other
options are signed.OLS, optim, random.forest,
\code{sample.splitting} (default "loo") either leave-one-out
(loo) or no splitting (none), \code{score.type} (default
"mean_absolute") specifies the type of score funtion to use
(note that "mean" and "max" are proportional scores which should
be used if the noise variance is expected to change across
experiments, if this is not the case "mean_absolute" and
"max_absolute" are prefered as they also work for perfect
unconstrained spline fits), \code{integrated.model} (default
TRUE) specifies whether to fit the integrated or the derived
model, \code{splitting.env} (default NA) an additonal
environment vector used for scoring, \code{weight.vec} (default
rep(1, length(env)) a weight vector used when
scoring.type=="weighted.mean", \code{set.initial} (default
FALSE) specifies whether to fix the initial value, \code{silent}
(default TRUE) turn of additional output, \code{show.plot}
(default FALSE) show diagnostic plots.}
}
\value{
returns a vector with the same length as models containing
  the stability scores
}
\description{
Applies CausalKinetiX framework to rank a list models according to
their stability.
}
\details{
This function scores a specified list of models and does not
include a variable ranking.
}
\examples{
## Generate data from Maillard reaction
simulation.obj <- generate.data.maillard(target=1,
                                         env=rep(1:5, 3),
                                         L=20,
                                         par.noise=list(noise.sd=1))
D <- simulation.obj$simulated.data
time <- simulation.obj$time
env <- simulation.obj$env
target <- simulation.obj$target

## Fit data to the following two models using CausalKinetiX:
## 1: dy = theta_1*x_1 + theta_2*x_2 + theta_3*x_1*x_10 (true model)
## 2: dy = theta_1*x_2 + theta_2*x_3*x_10 (wrong model)
ck.fit <- CausalKinetiX.modelranking(D, time, env, target,
                                     list(list(1, 2, c(1, 10)), list(2, 4, c(3, 10))))
print(ck.fit)
}
\references{
Pfister, N., S. Bauer, J. Peters (2018).
Identifying Causal Structure in Large-Scale Kinetic Systems
ArXiv e-prints (arXiv:1810.11776).
}
\seealso{
The function \code{\link{CausalKinetiX}} is a wrapper for
  this function that also computes the variable ranking and
  generates sensible classes of models.
}
\author{
Niklas Pfister, Stefan Bauer and Jonas Peters
}
