#' Create parameter documentation to inherit
#'
#' @param model A \code{causal_model}. A model object generated by \code{\link{make_model}}.
#' @param query A character string. An expression defining nodal types to interrogate \code{\link{realise_outcomes}}. An expression of the form "Y[X=1]" asks for the value of Y when X is set to 1
#' @param join_by A logical operator. Used to connect causal statements: \emph{AND} ('&') or \emph{OR} ('|'). Defaults to '|'.
#' @param parameters A vector of real numbers in [0,1]. Values of parameters to specify (optional). By default, parameters is drawn from \code{model$parameters_df}.
#' @param P A \code{data.frame}. Parameter matrix. Not required but may be provided to avoid repeated computation for simulations.
#' @param A A \code{data.frame}. Ambiguity matrix. Not required but may be provided to avoid repeated computation for simulations.
#' @param data A \code{data.frame}.  Data of nodes that can take three values: 0, 1, and NA. In long form as generated by \code{\link{make_events}}
#' @param data_events A \code{data.frame}. It must be compatible with nodes in \code{model}. The default columns are \code{event}, \code{strategy} and \code{count}.
#' @param node A character string. The quoted name of a node.
#' @param statement A character string. A quoted causal statement.
#' @param using A character string. Indicates whether to use `priors`, `posteriors` or `parameters`.
#' @param n_draws An integer. If no prior distribution is provided, generate prior distribution with \code{n_draws} number of draws.
#'
#' @return This function does not return anything. It is used to inherit roxygen documentation
#' @keywords internal
#'
CausalQueries_internal_inherit_params <- function(model, query, join_by, parameters, P, A,  data, data_events, node, statement, using, n_draws){

}
