% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/set_prior_distribution.R
\name{make_prior_distribution}
\alias{make_prior_distribution}
\title{Make a prior distribution from priors}
\usage{
make_prior_distribution(model, n_draws = 4000)
}
\arguments{
\item{model}{A \code{causal_model}. A model object generated by
\code{\link{make_model}}.}

\item{n_draws}{A scalar. Number of draws.}
}
\value{
A `data.frame` with dimension `n_param`x `n_draws` of possible
  lambda draws
}
\description{
Create a `n_param`x `n_draws` database of possible lambda draws to be
attached to the model.
}
\examples{
make_model('X -> Y') |>
  CausalQueries:::make_prior_distribution(n_draws = 5)

}
\concept{prior_distribution}
\keyword{internal}
