% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cep_mtm.R
\name{cep.mtm}
\alias{cep.mtm}
\title{Multitaper Estimation of Cepstral Coefficients and the Log-Spectrum}
\usage{
cep.mtm(x,nw,k)
}
\arguments{
\item{x}{Univariate time series of length N.}

\item{nw}{Width of tapers. Default is set to 4}

\item{k}{Number of tapers. Default is set to 7}
}
\value{
a list with 4 elements
\item{quef}{Quefencies.}
\item{cep}{Raw cepstra coefficients from 0:(N-1)}
\item{freq}{Frequencies between 0 and 1}
\item{lspec}{Log-spectrum.}
}
\description{
Returns multitaper estimated cepstra coefficients and log-spectrum for univariate time series.
}
\examples{
## simulate a time series
N = 500 #length of each series
dat <- r.cond.ar2(N=N,nj=1,r.phi1=c(.01,.7),r.phi2=c(-.12,-.06),r.sig2=c(.3,3))$X

## Fit multiaper
cep <- cep.mtm(dat)

## Plot the cepstral coefficients
plot(cep$quef, cep$cep)

## Plot the log spectrum
plot(cep$freq, cep$lspec, type="l")
}
\author{
Robert Krafty \email{<rkrafty@pitt.edu>}
}

