% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/removeGroupSamples.R
\name{removeGroup}
\alias{removeGroup}
\alias{removeSample}
\title{Remove Groups or Samples from a Spectra or Spectra2D Object}
\usage{
removeGroup(spectra, rem.group)

removeSample(spectra, rem.sam)
}
\arguments{
\item{spectra}{An object of S3 class \code{\link[ChemoSpec]{Spectra}} or 
\code{Spectra2D}.}

\item{rem.group}{A character vector (possibly a regex) giving the groups to be removed.}

\item{rem.sam}{Either an integer vector specifying the samples to be
removed, or a character vector (possibly a regex) giving the sample names to be removed.}
}
\value{
An object of S3 class \code{\link[ChemoSpec]{Spectra}} or \code{Spectra2D}.
}
\description{
Removes specified groups or samples from a \code{\link[ChemoSpec]{Spectra}} or
\code{Spectra2D} object.
}
\details{
Both functions will report if extra data elements are found.  These will
probably need to be edited manually.  The indices reported to the console
can be helpful in this regard.

If \code{rem.sam} or \code{rem.group} is a character vector, the sample
names are grepped for the corresponding values.  Remember that the
grepping process is greedy, i.e. grepping for "XY" find not only "XY" but
also "XYZ".

Unused levels in \code{$groups} are dropped.
}
\section{Functions}{
\itemize{
\item \code{removeGroup}: Remove groups from a \code{Spectra} or \code{Spectra2D} object

\item \code{removeSample}: Remove samples from a \code{Spectra} or \code{Spectra2D} object
}}

\examples{
if (requireNamespace("ChemoSpec", quietly = TRUE)) {
  library("ChemoSpec")
  data(SrE.IR)

  # Remove a group
  sumGroups(SrE.IR)
  SrE.IRa <- removeGroup(SrE.IR, rem.group = "pSrE")
  sumGroups(SrE.IRa)
  
  # Remove the 9th spectrum/sample:
  SrE.IR$names
  SrE.IRb <- removeSample(SrE.IR, rem.sam = 9)
  SrE.IRb$names

  # Removes a spectrum/sample with this exact name:
  SrE.IRc <- removeSample(SrE.IR, rem.sam = "NW_adSrE")
  SrE.IRc$names
}

if (requireNamespace("ChemoSpec2D", quietly = TRUE)) {
  library("ChemoSpec2D")
  data(MUD1)
  sumGroups(MUD1)
  MUD1a <- removeGroup(MUD1, rem.group = "GroupA")
  sumGroups(MUD1a)
}

}
\seealso{
\code{\link{removeFreq}} to remove selected frequencies.
}
\author{
Bryan A. Hanson, DePauw University.
}
\keyword{utilities}
