% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_productions_page.R
\name{make_productions_page}
\alias{make_productions_page}
\title{Generate HTML page with productions list and summary chart}
\usage{
make_productions_page(lattes.list, chart.type = c("ggplot2", "plotly",
  "rCharts"), chart.width = 960, chart.height = 480,
  h1.title = "My Laboratory<br/>My Department<br/>My University",
  h2.title = "Academic Productions", language = c("EN", "PT"),
  which.fields = c("journal.accepted", "journal.published",
  "conference.international", "conference.national", "book.chapters", "books",
  "phd.theses", "msc.theses"))
}
\arguments{
\item{lattes.list}{a Lattes list object created using \code{\link[=lattes_to_list]{lattes_to_list()}}}

\item{chart.type}{package to use for generating the summary chart. "plotly" and
"rCharts" output interactive charts, "ggplot2" outputs a static one.}

\item{chart.width}{plot width (for "plotly" and "rCharts")}

\item{chart.height}{plot height (for "plotly")}

\item{h1.title}{H1 title for the page}

\item{h2.title}{H2 subtitle for the page}

\item{language}{Language to use in section headers}

\item{which.fields}{Character vector indicating which fields to include in
the productions page.}
}
\description{
This function generates an HTML page with productions list and summary chart.
Use chart.type = "plotly" for an interactive plot, and "ggplot2"
for a static one. Option "rCharts" is currently disabled, until the rCharts
package (\url{https://github.com/ramnathv/rCharts})
becomes available on CRAN.
}
\examples{

# Load example data and convert it to a lattes list
CV.dir <- system.file("extdata", package="ChocoLattes")

# Define the aliases of authors "Felipe Campelo" and "Lucas S. Batista":
# (all aliases will be converted to the first name provided for each author)
my.aliases <- list(c("Felipe Campelo",
                     "Felipe Campelo Franca Pinto",
                     "Felipe Campelo F. Pinto",
                     "F.C.F. Pinto"),
                   c("Lucas S. Batista",
                     "Lucas Batista",
                     "Lucas de Souza Batista",
                     "Lucas Souza Batista"))

lattes.list <- lattes_to_list(CV.dir         = CV.dir,
                              author.aliases = my.aliases)


# Build productions page:
make_productions_page(lattes.list,
                      chart.type     = "ggplot2",
                      h1.title       = "ORCS Lab",
                      h2.title       = "UFMG, Brazil",
                      language       = "EN")

}
