% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/getSolutions.R
\name{getSolutions}
\alias{getSolutions}
\title{Evaluate parameter uncertainty}
\usage{
getSolutions(data, p, n, tol = 0.01, interc = c(0, 0.05), et_mult = c(1,
  1.1), flow_mult = c(1, 1.1), open_wat = c(0.01, 0.1), run_mult = c(1,
  5), run_css = c(0.1, 1), bf_mult = c(0.5, 1.5), nonrev = c(0.05, 0.2),
  ind_evap = c(0.01, 0.02), wast_gen = c(0.75, 0.9), pot_atm = c(0.1,
  0.15), npot_infilt = c(0.25, 0.75), slud_evap = c(0, 0),
  leak_css = c(0.05, 0.25), dgw = c(0.5, 0.5), dgw_rep = c(0, 1),
  global_bal = c(-500, 500), sw_bal = c(-500, 500), css_bal = c(-500,
  500), sgw_bal = c(-500, 500), dgw_bal = c(-500, 500))
}
\arguments{
\item{data}{xts or zoo object. See CityWaterBalance function for details.}

\item{p}{list of initial parameter values. See CityWaterBalance function or
the inputs below for descriptions.}

\item{n}{integer number of initial parameter sets to search}

\item{tol}{tolerance acceptable difference mean flow solutions}

\item{interc}{vector of min and max fraction of pet lost to interception}

\item{et_mult}{vector of min and max multiplier for et}

\item{flow_mult}{vector of min and max multiplier for outflow}

\item{open_wat}{vector of min and max fraction of area that is open water}

\item{run_mult}{vector of min and max multiplier for runoff}

\item{run_css}{vector of min and max fraction of runoff diverted to sewers}

\item{bf_mult}{vector of min and max multiplier for baseflow}

\item{nonrev}{vector of min and max fraction of potable water supply lost to 
leaks}

\item{ind_evap}{vector of min and max fraction of industrial use that 
evaporates}

\item{wast_gen}{vector of min and max fraction of potable use that returns to 
sewers}

\item{pot_atm}{vector of min and max fraction of potable use that evaporates}

\item{npot_infilt}{vector of min and max fraction of nonpotable use that 
infiltrates}

\item{slud_evap}{vector of min and max fraction of wastewater that evaporates 
from sludge}

\item{leak_css}{vector of min and max fraction of wastewater effluent from gw 
infiltration}

\item{dgw}{vector of min and max fraction of groundwater from deep, confined 
aquifers}

\item{dgw_rep}{vector of min and max multiplier for deep groundwater pumping 
replacement}

\item{global_bal}{vector of min and max acceptable global water balance 
values, cumulative over model run}

\item{sw_bal}{vector of min and max acceptable surface water balance 
values, cumulative over model run}

\item{css_bal}{vector of min and max acceptable sewer system water balance 
values, cumulative over model run}

\item{sgw_bal}{vector of min and max acceptable shallow groundwater balance 
values, cumulative over model run}

\item{dgw_bal}{vector of min and max acceptable deep groundwater balance 
values, cumulative over model run}
}
\value{
out numeric solutions
}
\description{
This function searches for acceptable model solutions within the uncertainty 
parameters and long-term storage balances using Latin hypercubes.
}
\details{
The function creates n parameter sets using a Latin hypercube.  It runs
`CityWaterBalance()` with each set, accepting solutions that meet 
user-defined criteria for storage balances.  It then computes the mean of 
flow solutions, and doubles n until the difference between the means of old 
and new solutions is less than tol for all flows.  Defaults for parameter 
value ranges are set to reasonable values, but they should be reconsidered 
for each application.  Defaults for storage balances are set high to allow
for solution discovery, however, acceptable values must be determined on a 
case-by-case basis.
}
\examples{
\dontrun{
data <- cwb_data
data$cso <- 0
p <- list("interc" = 0,"et_mult" = 1,"flow_mult" = 1, "open_wat" = 0.02, 
          "run_mult" = 3.378, "run_css" = 0.35, "bf_mult" = 1, 
          "nonrev" = 0.08, "ind_evap" = 0.012, "wast_gen" = 0.85, 
          "pot_atm" = 0.13, "npot_infilt" = 0.5, "slud_evap" = 0,
          "leak_css" = 0.05, "dgw" = 0.5, "dgw_rep" = 0.5)
out <- getSolutions(data, p, 10, 0.1)
}
}
