% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PlotCharacterChanges.R
\name{PlotCharacterChanges}
\alias{PlotCharacterChanges}
\title{Plots character changes on branches}
\usage{
PlotCharacterChanges(character.changes, tree)
}
\arguments{
\item{character.changes}{A matrix of character changes.}

\item{tree}{Tree on which character changes occur.}
}
\value{
A plot of character changes on a tree.
}
\description{
Plots character changes in boxes on branches.
}
\details{
Takes the \code{character.changes} output from \link{DiscreteCharacterRate} and plots it on the tree used to generate it.
}
\examples{

# Set random seed:
set.seed(17)

# Generate a random tree for the Michaux data set:
tree <- rtree(nrow(Michaux1989$Matrix_1$Matrix))

# Update taxon names to match those in the data matrix:
tree$tip.label <- rownames(Michaux1989$Matrix_1$Matrix)

# Set root time by making youngest taxon extant:
tree$root.time <- max(diag(vcv(tree)))

# Get discrete character rates (includes changes):
out <- DiscreteCharacterRate(tree, Michaux1989,
  seq(tree$root.time, 0, length.out = 3),
  BranchPartitionsToTest = list(list(1)), Alpha = 0.01)

# Plot character changes on the tree:
PlotCharacterChanges(out$InferredCharacterChanges,
  tree)

}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
