% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/find_linked_edges.R
\name{find_linked_edges}
\alias{find_linked_edges}
\title{Find linked edges for a tree}
\usage{
find_linked_edges(tree)
}
\arguments{
\item{tree}{A tree (phylo object).}
}
\value{
Returns a matrix where links are scored 1 and everything else 0. The diagonal is left as zero.
}
\description{
Given a tree finds edges that are linked to each other.
}
\details{
Finds all edges that link (share a node) with each edge of a tree.

This is intended as an internal function, but may be of use to someone else.
}
\examples{

# Create a simple four-taxon tree:
tree <- ape::read.tree(text = "(A,(B,(C,D)));")

# Find linked (1) edges matrix for tree:
find_linked_edges(tree)
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
