% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/map_dollo_changes.R
\name{map_dollo_changes}
\alias{map_dollo_changes}
\title{Stochastic Character Map For Dollo Character}
\usage{
map_dollo_changes(time_tree, tip_states)
}
\arguments{
\item{time_tree}{A tree in phylo format with positive branch lengths and a value for \code{$root.time}.}

\item{tip_states}{A named vector of tip states (must be 0 or 1), where the names match \code{tree$tip.label}.}
}
\value{
\item{changes}{A matrix of all changes (gains and losses).}
\item{stochastic_character_map}{The stochastic character map.}
}
\description{
Given a tree with binary tip states produces a stochastic Dollo character map.
}
\details{
The non-ideal solution from Tarver et al. (2018) to the problem of generating a stochastic character map for a Dollo character (i.e., a single gain of the derived state, 1) with any number of losses (1 -> 0).

The function operates as follows:

1) Establishes the least inclusive clade exhibiting the derived state (1).
2) Assumes a single gain occurred with equal probability along the branch subtending this clade.
3) Prunes the inclusive clade to generate a subtree with a strong root prior of the derived state (1).
4) Calls \code{make.simmap} from the \code{phytools} package to generate a stochastic character map using a model where only losses are possible.
5) Outputs both the stochastic character map (time spent in each state on each branch) and a matrix of state changes.

NB: As the map is stochastic the answer will be different each time the function is run and multiple replicates are strongly advised in order to characterise this uncertainty.
}
\examples{

# Build example ten-tip tree:
time_tree <- ape::read.tree(text = paste0("(A:1,(B:1,((C:1,(D:1,(E:1,F:1):1):1):1,",
  "((G:1,H:1):1,(I:1,J:1):1):1):1):1);"))

# Arbitrarily add a root.time value of 100 Ma:
time_tree$root.time <- 100

# Build example tip state values:
tip_states <- c(A = 0, B = 0, C = 1, D = 1, E = 0, F = 1, G = 1, H = 1, I = 0, J = 1)

# Run map_dollo_changes on data and store output:
out <- map_dollo_changes(time_tree, tip_states)

# View matrix of changes:
out$changes

# View stochastic character map (time spent in each state on each branch):
out$stochastic_character_map
}
\references{
Tarver, J. E., Taylor, R. S., Puttick, M. N., Lloyd, G. T., Pett, W., Fromm, B., Schirrmeister, B. E., Pisani, D., Peterson, K. J. and Donoghue, P. C. J., 2018. Well-annotated microRNAomes do not evidence pervasive miRNA loss. \emph{Genome Biology and Evolution}, \bold{6}, 1457-1470.
}
\author{
Graeme T. Lloyd \email{graemetlloyd@gmail.com}
}
