% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/problemdata.R
\name{problemdata}
\alias{problemdata}
\title{Claims problem data}
\usage{
problemdata(E, d, draw = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{draw}{A logical value.}
}
\value{
The minimal rights vector; the truncated claims vector; the sum, the half-sum of the claims, and the class (lower-half, higher-half, and midpoint domains) to which the claims problem belongs. It returns cod  = 1 if the claims problem belong to the lower-half domain, cod  =  -1  if it belongs to the higher-half domain, and cod = 0  for the midpoint domain.  Moreover, if  draw = TRUE a plot of the claims, from small to large in the interval [0,D], is given.
}
\description{
The function returns to which of the following sub-domains the claims problem belongs to:  the lower-half, higher-half, and  midpoint domains. In addittion, the function returns
the minimal rights vector, the truncated claims vector, the sum and the half-sum of claims.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di \ge E}, the sum of claims \eqn{D} exceeds the endowment.

The lower-half domain is the sub-domain of claims problems for which the endowment is less or equal than the half-sum of claims, \eqn{E \le  D/2}.

The higher-half domain is the sub-domain of claims problems for which the endowment is greater or equal than the half-sum of claims, \eqn{E \ge  D/2}.

The midpoint domain is the sub-domain of claims problems for which the endowment is equal to the half-sum of claims, \eqn{E =  D/2}.

The minimal right of claimant \eqn{i} in \eqn{(E,d)} is whatever is left after every other claimant has received his claim, or 0 if that is not possible:
\deqn{m_i(E,d)=\max\{0,E-d(N\backslash\{i\})\},\ i=1,\dots,n.}{mi = max\{ 0 , E-d(N-\{i\}) \}, i=1,\dots,n.}
Let \eqn{m(E,d)=(m_1(E,d),\dots,m_n(E,d))}{m(E,d)=(m1,\dots,mn)} be the vector of minimal rights.

The truncated claim of claimant \eqn{i} in \eqn{(E,d)} is the minimum of the claim and the endowment:
\deqn{t_i(E,d)=\min\{d_i,E\},\ i=1,\dots,n.}{ti = min\{di,E\}, i=1,\dots,n.}
Let \eqn{t(E,d)=(t_1(E,d),\dots,t_n(E,d))}{t(E,d)=(t1,\dots,tn)} be the vector of truncated claims.
}
\examples{
E=10
d=c(2,4,7,8)
problemdata(E,d,draw=TRUE)
}
\seealso{
\link{setofawards}, \link{allrules}
}
