% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/PRO.R
\name{PRO}
\alias{PRO}
\title{Proportional rule}
\usage{
PRO(E, d, name = FALSE)
}
\arguments{
\item{E}{The endowment.}

\item{d}{The vector of claims.}

\item{name}{A logical value.}
}
\value{
The awards vector selected by the PRO rule. If name = TRUE, the name of the function (PRO) as a character string.
}
\description{
This function returns the awards vector assigned by the proportional rule (PRO) to a claims problem.
}
\details{
Let \eqn{E\ge 0} be the endowment to be divided and \eqn{d\in \mathcal{R}^n}{d} the vector of claims
with \eqn{d\ge 0} and such that \eqn{D=\sum_{i=1}^{n} d_i\ge E}{D=\sum di \ge E}, the sum of claims \eqn{D} exceeds the endowment.

The proportional rule distributes awards proportional to claims.
\deqn{PRO(E,d)=\frac{E}{D}d}{PRO(E,d)=(E/D)*d}
}
\examples{
E=10
d=c(2,4,7,8)
PRO(E,d)
}
\references{
Aristotle, Ethics, Thompson, J.A.K., tr. 1985. Harmondsworth: Penguin.

Thomson, W. (2019). How to divide when there isn't enough. From Aristotle, the Talmud, and Maimonides to the axiomatics of resource allocation. Cambridge University Press.
}
\seealso{
\link{allrules}, \link{APRO}
}
