% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rerank.R
\name{rerank.netcdf.wrapper}
\alias{rerank.netcdf.wrapper}
\title{High-level NetCDF wrapper for Quantile Reranking}
\usage{
rerank.netcdf.wrapper(qdm.file, obs.file, analogues, out.file,
  varname = "tasmax")
}
\arguments{
\item{qdm.file}{The output file from the QDM script}

\item{obs.file}{Filename of high-res gridded historical observations}

\item{analogues}{Temporal analogues... describe this more}

\item{out.file}{The file to create (or overwrite) with the final NetCDF output}

\item{varname}{Name of the NetCDF variable to downscale (e.g. 'tasmax')}
}
\description{
All files (save for the analogues_file) should have the same spatial domain.
}
\references{
Schefzik, R., Thorarinsdottir, T. L., & Gneiting, T. (2013). Uncertainty quantification in complex simulation models using ensemble copula coupling. Statistical Science, 28(4), 616-640.

Wilks, D. S. (2015). Multivariate ensemble Model Output Statistics using empirical copulas. Quarterly Journal of the Royal Meteorological Society, 141(688), 945-952.
}

