% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/temperature.R
\name{temperature}
\alias{temperature}
\title{Temperature indices}
\usage{
temperature(object, day.one = NULL, span = NULL, index = NULL, ...)
}
\arguments{
\item{object}{a numeric vector of geographic coordinates (lonlat) or
an array with two dimensions containing the temperature data;
1st dimension contains the day temperature and 2nd dimension the night temperature.
When lonlat is used, the function makes a call to
\code{nasapower::get_power} to fetch and concatenate environmental data from NASA POWER
(\url{https://power.larc.nasa.gov/})}

\item{day.one}{a vector of class 'Date' for the starting date to capture the environmental data}

\item{span}{an integer or a vector with integers for the duration of the timespan to be captured}

\item{index}{optional, a character or a vector with characters for the indices to be computed. 
All indices are given by default}

\item{...}{additional arguments passed to methods}
}
\value{
A dataframe with selected indices. Options are:
\item{maxDT}{maximun day temperature (degree Celsius)}
\item{minDT}{minimum day temperature (degree Celsius)}
\item{maxNT}{maximun night temperature (degree Celsius)}
\item{minNT}{minimum night temperature (degree Celsius) }
\item{DTR}{diurnal temperature range (mean difference between DT and NT (degree Celsius)) }
\item{SU}{summer days, number of days with maximum temperature > 30 (degree Celsius)}
\item{TR}{tropical nights, number of nights with maximum temperature > 25 (degree Celsius) }
}
\description{
Compute temperature indices over a timespan
}
\examples{
\donttest{

library("ClimMobTools")
library("nasapower")

# random geographic locations around bbox(11, 12, 55, 58)
lonlat <- data.frame(lon = runif(10, 11, 12),
                     lat = runif(10, 55, 58))

# random planting dates around 2018-05-15 and 2018-05-20
pdates <- as.integer(runif(10, 17666, 17670))
pdates <- as.Date(pdates, origin = "1970-01-01")

# get temperature indices for the first 40 days
temperature(lonlat,
            day.one = pdates,
            span = 40)
}
}
