% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rankTricot.R
\name{rankTricot}
\alias{rankTricot}
\title{Build Plackett-Luce rankings from tricot dataset}
\usage{
rankTricot(
  data,
  items,
  input,
  group = FALSE,
  validate.rankings = FALSE,
  additional.rank = NULL,
  ...
)
}
\arguments{
\item{data}{a data.frame with columns specified by items and input values}

\item{items}{a character or numerical vector for indexing the column(s) 
containing the item names in \code{data}}

\item{input}{a character or numerical vector for indexing the column(s) 
containing the values in \code{data} to be ranked}

\item{group}{logical, if \code{TRUE} return an object of class "grouped_rankings"}

\item{validate.rankings}{logical, if \code{TRUE} implements a check on ranking consistency 
looking for possible ties, NA or letters other than A, B, C. These entries are set to 0}

\item{additional.rank}{optional, a data frame for the comparisons between 
tricot items and the local item}

\item{...}{additional arguments passed to methods. See details}
}
\value{
a PlackettLuce "rankings" or "grouped_rankings" object
}
\description{
Create an object of class "rankings" from tricot data
}
\details{
full.output: logical, to return a list with a "rankings", 
a "grouped_rankings" and the ordered items
}
\examples{
\dontshow{if (interactive()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
# beans data where each observer compares 3 varieties randomly distributed
# from a list of 11 and additionally compares these 3 varieties
# with their local variety
if (require("PlackettLuce")){
  data("beans", package = "PlackettLuce")
  
  # first build rankings with only tricot items
  # and return an object of class 'rankings'
  R = rankTricot(data = beans,
                  items = c(1:3),
                  input = c(4:5))
  head(R)
  
  ############################################################
  
  # pass the comparison with local item as an additional rankings, then
  # each of the 3 varieties are compared separately with the local item
  # and return an object of class grouped_rankings
  G = rankTricot(data = beans,
                  items = c(1:3),
                  input = c(4:5),
                  group = TRUE,
                  additional.rank = beans[c(6:8)])
  
  head(G)
}
\dontshow{\}) # examplesIf}
}
\references{
van Etten J., et al. (2019). Experimental Agriculture, 55(S1), 275–296.
\doi{10.1017/S0014479716000739}
}
\author{
Kauê de Sousa and Jacob van Etten, with ideas from Heather Turner
}
