% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ang.minus.R
\name{ang.minus}
\alias{ang.minus}
\title{Angular subtraction}
\usage{
ang.minus(x, y)
}
\arguments{
\item{x, y}{angular data(scalar or vector) whose elements are in \eqn{[0, 2\pi)}}
}
\value{
returns a scalar or a vector whose elements are in
  \eqn{[-\pi, \pi)}.
}
\description{
\code{ang.minus} computes element-wise angular subtraction defined as
\deqn{x -  y := Arg(exp(i(x-y)))}
}
\examples{
x <- c(pi/2, 0)
y <- c(pi, pi/3)

ang.minus(x, y)
}
\references{
S. Jung, K. Park, and B. Kim (2021),
  "Clustering on the torus by conformal prediction"
}
