% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ECS.R
\name{element_sim}
\alias{element_sim}
\title{The Element-Centric Clustering Similarity}
\usage{
element_sim(clustering1, clustering2)
}
\arguments{
\item{clustering1}{The first Clustering.}

\item{clustering2}{The second Clustering.}
}
\value{
The average element-wise similarity between the two Clusterings.
}
\description{
Calculates the average element-centric similarity between two
Clustering objects.
}
\examples{
km.res = kmeans(mtcars, 3)$cluster
km.clustering = create_clustering(km.res)
hc.res = hclust(dist(mtcars))
hc.clustering = create_clustering(hc.res)
element_sim(km.clustering, hc.clustering)
}
