% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/stability-based-parameter-assessment.R
\name{plot_n_neigh_ecs}
\alias{plot_n_neigh_ecs}
\title{Graph construction parameters - ECC facet}
\usage{
plot_n_neigh_ecs(nn_ecs_object)
}
\arguments{
\item{nn_ecs_object}{An object or a concatenation of objects returned by the
`get_nn_importance` method.}
}
\value{
A ggplot2 object.
}
\description{
Display, for all configurations consisting in different number
of neighbors, graph types and base embeddings, the EC Consistency of the partitions
obtained over multiple runs on an UMAP embedding.
}
\examples{
set.seed(2021)
# create an artificial expression matrix
expr_matrix = matrix(c(runif(100*10), runif(100*10, min=5, max=6)), nrow = 200)
rownames(expr_matrix) = as.character(1:200)

nn_importance_obj = get_nn_importance(object = expr_matrix,
    n_neigh_sequence = c(10,15,20),
    n_repetitions = 10,
    graph_reduction_type = "PCA",
    algorithm = 1,
    transpose = FALSE, # the matrix is already observations x features, so we won't transpose it
    # the following parameter is used by the irlba function and is not mandatory
    nv = 2)
plot_n_neigh_ecs(nn_importance_obj)
}
