% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/clustering_functions.R
\name{Optimal_Clusters_Medoids}
\alias{Optimal_Clusters_Medoids}
\title{Optimal number of Clusters for the partitioning around Medoids functions}
\usage{
Optimal_Clusters_Medoids(data, max_clusters, distance_metric,
  criterion = "dissimilarity", clara_samples = 0,
  clara_sample_size = 0, minkowski_p = 1, swap_phase = TRUE,
  threads = 1, verbose = FALSE, plot_clusters = TRUE, seed = 1)
}
\arguments{
\item{data}{matrix or data.frame. If both clara_samples and clara_sample_size equal 0, then the data parameter can be also a dissimilarity matrix, where the main diagonal equals 0.0 and the number of rows equals the number of columns}

\item{max_clusters}{the maximum number of clusters}

\item{distance_metric}{a string specifying the distance method. One of,  \emph{euclidean},  \emph{manhattan},  \emph{chebyshev},  \emph{canberra},  \emph{braycurtis},  \emph{pearson_correlation},  \emph{simple_matching_coefficient},  \emph{minkowski},  \emph{hamming},  \emph{jaccard_coefficient},  \emph{Rao_coefficient},  \emph{mahalanobis}}

\item{criterion}{one of 'dissimilarity' or 'silhouette'}

\item{clara_samples}{number of samples to draw from the data set in case of clustering large applications (clara)}

\item{clara_sample_size}{fraction of data to draw in each sample iteration in case of clustering large applications (clara). It should be a float number greater than 0.0 and less or equal to 1.0}

\item{minkowski_p}{a numeric value specifying the minkowski parameter in case that distance_metric = "minkowski"}

\item{swap_phase}{either TRUE or FALSE. If TRUE then both phases ('build' and 'swap') will take place. The 'swap_phase' is considered more computationally intensive.}

\item{threads}{an integer specifying the number of cores to run in parallel. Openmp will be utilized to parallelize the number of sample draws}

\item{verbose}{either TRUE or FALSE, indicating whether progress is printed during clustering}

\item{plot_clusters}{TRUE or FALSE, indicating whether the iterative results should be plotted. See the details section for more information}

\item{seed}{integer value for random number generator (RNG)}
}
\value{
a list of length equal to the max_clusters parameter (the first sublist equals NULL, as dissimilarities and silhouette widths can be calculated if the number of clusters > 1). If plot_clusters is TRUE then the function plots also the results.
}
\description{
Optimal number of Clusters for the partitioning around Medoids functions
}
\details{
In case of plot_clusters = TRUE, the first plot will be either a plot of dissimilarities or both dissimilarities and silhouette widths giving an indication of the optimal number
of the clusters. Then, the user will be asked to give an optimal value for the number of the clusters and after that the second plot will appear with either the dissimilarities or the
silhouette widths belonging to each cluster.
}
\examples{

\dontrun{
data(soybean)

dat = soybean[, -ncol(soybean)]

opt_md = Optimal_Clusters_Medoids(dat, 10, 'jaccard_coefficient', plot_clusters = FALSE)
}
}
\author{
Lampros Mouselimis
}
