% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ObtainigValueSPBal.R
\name{ObtainigValueSPBal}
\alias{ObtainigValueSPBal}
\title{Obtaining the selected principal balances values}
\usage{
ObtainigValueSPBal(Num, Dem, especie, Tt)
}
\arguments{
\item{Num}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the principal balance i are placed.}

\item{Dem}{List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the principal balance i are placed.}

\item{especie}{Matrix that contains at row i the bacterial taxa of bacteria i at all time points.}

\item{Tt}{Number of time points available}
}
\value{
Returns a list with:
\itemize{
  \item NumSPBal:  List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the numerator of the selected  principal balance i are placed.
  \item DemSPBal:  List. The component i of the list has the number of the row of the matrix \code{especie} where the bacteria in the denominator of the selected  principal balance i are placed.
   \item MatrixSPBal:  MatrixSPBal is the matrix that contains the covariates of the model. The first line es equal to 1 for all columns. The other rows contain the value of one SPBal at all time points. The selected principal balance of the row i+1 has at its numerator the bacteria placed in the rows \code{NumSPBal[[i]]} of the "especie". The selected principal balance of the row i+1 has at its denominator the bacteria placed in the rows \code{DemSPBal[[i]]} of the "especie".
  \item PercenVarianceSPBal: Vector. The component of the vector i contains the percentage of variance of the SPBal with numerator \code{NumSPBal[[i]]} and denominator \code{DemSPBal[[i]]}.
  }
}
\description{
Calculates the value of the selected principal balances (SPBal) of the BPBM model at all time points.
}
\examples{

set.seed(314)
esp2=t(gtools::rdirichlet(n=6, c(1,1,5,1,1)))

Num2<-list(3,c(3,5),1,c(3,5,4))
Dem2<-list(5,4,2,c(1,2))

ObtainigValueSPBal(Num2,Dem2,esp2,6)

}
\references{
Creus-Martí, I., Moya, A., Santonja, F. J. (2022). Bayesian hierarchical compositional models for analysing longitudinal abundance data from microbiome studies. Complexity, 2022.
}
