% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ClusterNodes.R
\name{ClusterNodes}
\alias{ClusterNodes}
\title{ClusterNodes}
\usage{
ClusterNodes(DiffNet, cutoff.external = 0.8, cutoff.internal = 0.5)
}
\arguments{
\item{DiffNet}{The Differential network from MakeDiffNet}

\item{cutoff.external}{The cut-off between the clusters (delta from the center to the edge coordinates), the closer to 1, the better.}

\item{cutoff.internal}{The cut-off inside the clusters (delta from the theoretical cluster to the edge coordinates), the closer to zero, the better.}
}
\description{
Categorize the Nodes into Phi and Phi tilde.
}
\examples{
DiffNet = MakeDiffNet (Data = list(CTR,  AST), Code = c('CTR', 'AST') )
Genes_Phi = ClusterNodes(DiffNet, cutoff.external = 0.5, cutoff.internal = 0.25)
table(Genes_Phi$Phi_tilde)

}
