% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/population.R
\name{PopulationStat}
\alias{PopulationStat}
\alias{populationstat}
\alias{popmean}
\alias{popsd}
\alias{popvar}
\alias{popcvar}
\alias{popskew}
\alias{popkurt}
\title{Population statistics}
\usage{
populationstat(stat = "mean", dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popmean(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popsd(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popvar(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popcvar(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popskew(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))

popkurt(dist, distarg, p0 = 0, distbounds = c(-Inf, Inf))
}
\arguments{
\item{stat}{define what you what to calculate - possible population desc. statistics ('mean', 'sd', 'var', 'cvar', 'skew', 'kurt')}

\item{dist}{distribution}

\item{distarg}{list of distribution arguments}

\item{p0}{probability zero}

\item{distbounds}{distribution bounds (default set to c(-Inf, Inf))}
}
\description{
Provides theoretical descriptive statistics
}
\examples{

library(CoSMoS)

## check population statistics
populationstat('mean', 'norm', list(mean = 2, sd = 1))
populationstat('sd', 'norm', list(mean = 2, sd = 1))
populationstat('var', 'norm', list(mean = 2, sd = 1))
populationstat('cvar', 'norm', list(mean = 2, sd = 1))
populationstat('skew', 'norm', list(mean = 2, sd = 1))
populationstat('kurt', 'norm', list(mean = 2, sd = 1))

}
\keyword{internal}
