% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ctmaBiG.R
\name{ctmaBiG}
\alias{ctmaBiG}
\title{ctmaBiG}
\usage{
ctmaBiG(
  ctmaInitFit = NULL,
  activeDirectory = NULL,
  PETPEESEalpha = 0.1,
  activateRPB = FALSE,
  digits = 4,
  zcurve = FALSE,
  undoTimeScaling = TRUE
)
}
\arguments{
\item{ctmaInitFit}{fit object created with \code{\link{ctmaInit}} containing the fitted ctsem model of each primary study}

\item{activeDirectory}{the directory where to save results (if not specified, it is taken from ctmaInitFit)}

\item{PETPEESEalpha}{probability level (condition) below which to switch from PET to PEESE (cf. Stanley, 2017, p. 582, below Eq. 2; default p = .10)}

\item{activateRPB}{if TRUE, messages (warning, finished) could be send to smart phone (default = FALSE)}

\item{digits}{rounding (default = 4)}

\item{zcurve}{performs z-curve analysis. Could fail if too few studies (e.g. around 10) are supplied. default=FALSE}

\item{undoTimeScaling}{if TRUE, the original time scale is used (timeScale argument possibly used in \code{\link{ctmaInit}} is undone )}
}
\value{
ctmaBiG returns a list containing some arguments supplied, the results of analyses of publication bias and generalizability,
model type, and the type of plot that could be performed with the returned object. The arguments in the returned object are activeDirectory,
and coresToUse. Further arguments, which are just copied from the init-fit object supplied, are, n.studies, n.latent, studyList,
statisticsList, modelResults (all parameter estimates and their standard error), and parameter names. All new results are returned
as the list element "summary", which is printed if the summary function is applied to the returned object. The summary list element
comprises a title (model='Analysis of Publication Bias & Generalizability') and "estimates", which is another list comprising
"Fixed Effects of Drift Coefficients", "Heterogeneity", "Random Effects of Drift Coefficients", "PET-PEESE corrections",
"Egger's tests" (constant of the WLS regression of drift coefficients on their standard errors (SE) with 1/SE^2 as weights),
"Egger's tests Alt. Version" (constant of the OLS regression of the standard normal deviates of the drift coefficients on their
precision), and "Z-Curve 2.0 Results". Plot type is plot.type=c("funnel", "forest") and model.type="BiG".
}
\description{
Analysis of publication bias and generalizability. The function takes a CoTiMA fit object (created with \code{\link{ctmaInit}})
and estimates fixed and random effects of single drift coefficients, heterogeneity  (Q, I square, H square, tau square),
PET-PEESE corrections, Egger's tests, and z-curve analysis yielding expected replication and detection rates (ERR, EDR).
}
\examples{
\dontrun{
# perform analyses of publication bias and generalizability
CoTiMAInitFit_D_BO$activeDirectory <- "/Users/tmp/" # adapt!
CoTiMABiG_D_BO <- ctmaBiG(ctmaInitFit=CoTiMAInitFit_D_BO, zcurve=FALSE)
}

# display results
summary(CoTiMABiG_D_BO)

\dontrun{
# get funnel & forest plots
CoTiMABiG_D_BO$activeDirectory <- "/Users/tmp/" # adapt!
plot(CoTiMABiG_D_BO)
}
}
