% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vocabUtilities.R
\name{getDescendants}
\alias{getDescendants}
\title{getDescendants}
\usage{
getDescendants(cdm, conceptId, withAncestor = FALSE, doseForm = NULL)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{conceptId}{concpet_id to search}

\item{withAncestor}{If TRUE, return column with ancestor. In case of multiple
ancestors, concepts will be separated by ";"}

\item{doseForm}{Only descendants codes with the specified drug dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}
}
\value{
The descendants of a given concept id
}
\description{
getDescendants
}
\examples{
cdm <- mockVocabRef()
getDescendants(cdm = cdm, conceptId = 1)
DBI::dbDisconnect(attr(cdm, "dbcon"), shutdown = TRUE)
}
