% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/drugCodes.R
\name{getATCCodes}
\alias{getATCCodes}
\title{Get descendant codes for ATC levels}
\usage{
getATCCodes(
  cdm,
  level = c("ATC 1st"),
  name = NULL,
  doseForm = NULL,
  doseUnit = NULL,
  routeCategory = NULL,
  type = "codelist"
)
}
\arguments{
\item{cdm}{cdm_reference via CDMConnector}

\item{level}{ATC level. Can be one or more of "ATC 1st", "ATC 2nd",
"ATC 3rd", "ATC 4th", and "ATC 5th"}

\item{name}{ATC name of interest. For example, c("Dermatologicals",
"Nervous System"), would result in a list of length two with the descendant
concepts for these two particular ATC groups.}

\item{doseForm}{Only descendants codes with the specified dose form
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{doseUnit}{Only descendants codes with the specified dose unit
will be returned. If NULL, descendant codes will be returned regardless
of dose unit}

\item{routeCategory}{Only descendants codes with the specified route
will be returned. If NULL, descendant codes will be returned regardless
of dose form.}

\item{type}{Can be "codelist", "codelist_with_details", or
"concept_set_expression"}
}
\value{
Concepts with their format based on the type argument.
}
\description{
Get descendant codes for ATC levels
}
\examples{
\donttest{
cdm <- mockVocabRef()
getATCCodes(cdm = cdm, level = "ATC 1st")
}
}
