% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortTiming.R
\name{plotCohortTiming}
\alias{plotCohortTiming}
\title{Plot summariseCohortTiming results.}
\usage{
plotCohortTiming(
  result,
  plotType = "boxplot",
  facetVarX = "variable_name",
  facetVarY = "group_level",
  colorVars = "group_level",
  timingLabel = "{cohort_name_reference} &&& {cohort_name_comparator}",
  uniqueCombinations = TRUE
)
}
\arguments{
\item{result}{A summariseCohortTiming result.}

\item{plotType}{Type of desired formatted table, possibilities are "boxplot" and
"density".}

\item{facetVarX}{column in data to facet by on horizontal axis}

\item{facetVarY}{column in data to facet by on vertical axis}

\item{colorVars}{Column names to distinct by colors. default set to group_level}

\item{timingLabel}{A glue expression to identify each plotted cohort
overlap.}

\item{uniqueCombinations}{If TRUE, only unique combinations of reference and
comparator plots will be plotted.}
}
\value{
A ggplot.
}
\description{
`r lifecycle::badge("experimental")`
}
\examples{
\donttest{
library(CohortCharacteristics)
cdm <- CohortCharacteristics::mockCohortCharacteristics()
timing <- summariseCohortTiming(cdm$cohort2)
plotCohortTiming(timing)
CDMConnector::cdmDisconnect(cdm = cdm)
}

}
