% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plotCohortAttrition.R
\name{plotCohortAttrition}
\alias{plotCohortAttrition}
\title{create a ggplot from the output of summariseLargeScaleCharacteristics.}
\usage{
plotCohortAttrition(result, cohortId = lifecycle::deprecated())
}
\arguments{
\item{result}{A summarised_result object. Output of
summariseCohortAttrition().}

\item{cohortId}{deprecated.}
}
\value{
A \code{grViz} visualisation.
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}
}
\examples{
\donttest{
library(CohortCharacteristics)
library(omopgenerics)
library(dplyr, warn.conflicts = FALSE)

cdm <- mockCohortCharacteristics(numberIndividuals = 1000)

cdm[["cohort1"]] <- cdm[["cohort1"]] |>
  filter(year(cohort_start_date) >= 2000) |>
  recordCohortAttrition("Restrict to cohort_start_date >= 2000") |>
  filter(year(cohort_end_date) < 2020) |>
  recordCohortAttrition("Restrict to cohort_end_date < 2020") |>
  compute(temporary = FALSE, name = "cohort1")

result <- summariseCohortAttrition(cdm$cohort1)

result |>
  filter(group_level == "cohort_2") |>
  plotCohortAttrition(cohortId = 2)

mockDisconnect(cdm)
}

}
