% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/trial_ocs.R
\name{trial_ocs}
\alias{trial_ocs}
\title{Calculates the operating characteristics of the cohort trial}
\usage{
trial_ocs(
  iter,
  coresnum = 1,
  save = FALSE,
  path = NULL,
  filename = NULL,
  ret_list = FALSE,
  ret_trials = FALSE,
  plot_ocs = FALSE,
  export = NULL,
  ...
)
}
\arguments{
\item{iter}{Number of program simulations that should be performed}

\item{coresnum}{How many cores should be used for parallel computing}

\item{save}{Indicator whether simulation results should be saved in an Excel file}

\item{path}{Path to which simulation results will be saved; if NULL, then save to current path}

\item{filename}{Filename of saved Excel file with results; if NULL, then name will contain design parameters}

\item{ret_list}{Indicator whether function should return list of results}

\item{ret_trials}{Indicator whether individual trial results should be saved as well}

\item{plot_ocs}{Should OCs stability plots be drawn?}

\item{export}{Should any other variables be exported to the parallel tasks?}

\item{...}{All other design parameters for chosen program}
}
\value{
List containing: Responses and patients on experimental and control arm, total treatment successes and failures and final p-value
}
\description{
Given the trial specific design parameters, performs a number
of simulations of the trial and saves the result in an Excel file
}
\examples{

random <- TRUE

rr_comb <- c(0.40, 0.45, 0.50)
prob_comb_rr <- c(0.4, 0.4, 0.2)
rr_mono <- c(0.20, 0.25, 0.30)
prob_mono_rr <- c(0.2, 0.4, 0.4)
rr_back <- c(0.20, 0.25, 0.30)
prob_back_rr <- c(0.2, 0.4, 0.4)
rr_plac <- c(0.10, 0.12, 0.14)
prob_plac_rr <- c(0.25, 0.5, 0.25)

rr_transform <- list(
  function(x) {return(c(0.75*(1 - x), (1-0.75)*(1-x), (1-0.75)*x, 0.75*x))},
  function(x) {return(c(0.85*(1 - x), (1-0.85)*(1-x), (1-0.85)*x, 0.85*x))}
)
prob_rr_transform <- c(0.5, 0.5)

cohorts_max <- 4
safety_prob <- 0
sharing_type <- "all"
trial_struc <- "all_plac"
sr_drugs_pos <- 4
n_int <- 100
n_fin <- 200
stage_data <- TRUE
cohort_random <- 0.05
target_rr <- c(0,0,1)
cohort_offset <- 0
random_type <- "absolute"
sr_first_pos <- FALSE
missing_prob <- 0.1

# Vergleich Combo vs Mono
Bayes_Sup1 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup1[1,] <- c(0.05, 0.90, 1.00)
Bayes_Sup1[2,] <- c(0.05, 0.65, 1.00)
Bayes_Sup1[3,] <- c(0.10, 0.50, 1.00)
# Vergleich Combo vs Backbone
Bayes_Sup2 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup2[1,] <- c(0.05, 0.90, 1.00)
Bayes_Sup2[2,] <- c(NA, NA, NA)
Bayes_Sup2[3,] <- c(NA, NA, NA)
# Vergleich Mono vs Placebo
Bayes_Sup3 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup3[1,] <- c(0.00, 0.90, 1.00)
Bayes_Sup3[2,] <- c(NA, NA, NA)
Bayes_Sup3[3,] <- c(NA, NA, NA)
# Vergleich Back vs Placebo
Bayes_Sup4 <- matrix(nrow = 3, ncol = 3)
Bayes_Sup4[1,] <- c(0.00, 0.90, 1.00)
Bayes_Sup4[2,] <- c(NA, NA, NA)
Bayes_Sup4[3,] <- c(NA, NA, NA)
Bayes_Sup <- list(list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4),
             list(Bayes_Sup1, Bayes_Sup2, Bayes_Sup3, Bayes_Sup4))

ocs <- trial_ocs(
n_int = n_int, n_fin = n_fin, random_type = random_type,
rr_comb = rr_comb, rr_mono = rr_mono, rr_back = rr_back, rr_plac = rr_plac,
rr_transform = rr_transform, random = random, prob_comb_rr = prob_comb_rr,
prob_mono_rr = prob_mono_rr, prob_back_rr = prob_back_rr, prob_plac_rr = prob_plac_rr,
stage_data = stage_data, cohort_random = cohort_random, cohorts_max = cohorts_max,
sr_drugs_pos = sr_drugs_pos, target_rr = target_rr, sharing_type = sharing_type,
sr_first_pos = sr_first_pos, safety_prob = safety_prob, Bayes_Sup = Bayes_Sup,
prob_rr_transform = prob_rr_transform, cohort_offset = cohort_offset,
trial_struc = trial_struc, missing_prob = missing_prob,
iter = 10, coresnum = 1, save = FALSE, ret_list = TRUE, plot_ocs = TRUE
)

ocs[[3]]

}
