% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/download_climate.R
\name{download_climate}
\alias{download_climate}
\title{Download climate from named geometry (municipality or department)}
\usage{
download_climate(code, start_date, end_date, tag)
}
\arguments{
\item{code}{character with the DIVIPOLA code for the area (2 digits for
departments and 5 digits for municipalities).}

\item{start_date}{character with the first date to consult in the format
\code{"YYYY-MM-DD"}. (First available date is \code{"1920-01-01"}).}

\item{end_date}{character with the last date to consult in the format
\code{"YYYY-MM-DD"}. (Last available date is \code{"2023-05-31"}).}

\item{tag}{character containing climate tag to consult. Please use
\code{cliamte_tags()} to check IDEAM tags.}
}
\value{
\code{data.frame} object with observations from the stations in the
area.
}
\description{
Download climate data from stations contained in a municipality or
department. This data is retrieved from local meteorological stations
provided by IDEAM.
}
\examples{
\donttest{
ptpm <- download_climate("73148", "2021-11-14", "2021-11-20", "PTPM_CON")
head(ptpm)
}

}
