% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/documentation.R
\name{geospatial_dictionary}
\alias{geospatial_dictionary}
\title{Download data dictionaries}
\usage{
geospatial_dictionary(spatial_level, language = "ES")
}
\arguments{
\item{spatial_level}{character with the spatial level to be consulted:
\itemize{
\item \code{"DPTO"} or \code{"department"}: Department.
\item \code{"MPIO"} or \code{"municipality"}: Municipality.
\item \code{"MPIOCL"} or \code{"municipality_class"}: Municipality including
class.
\item \code{"SETU"} or \code{"urban_sector"}: Urban Sector.
\item \code{"SETR"} or \code{"rural_sector"}: Rural Sector.
\item \code{"SECU"} or \code{"urban_section"}: Urban Section.
\item \code{"SECR"} or \code{"rural_section"}: Rural Section.
\item \code{"ZU" } or \code{"urban_zone"}: Urban Zone.
\item \code{"MZN"} or \code{"block"}: Block.
}}

\item{language}{character with the language of the dictionary variables
(\code{"EN"} or \code{"ES"}. Default is \code{"ES"}.}
}
\value{
\code{data.frame} object with geospatial data dictionary.
}
\description{
Retrieve geospatial data dictionaries to understand internal tags and named
columns. Dictionaries are available in English and Spanish.
}
\examples{
dict <- geospatial_dictionary("setu", "EN")
head(dict)

}
