% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/2_plGwas.R
\docType{methods}
\name{plGwas}
\alias{plGwas}
\alias{plGwas,PlGwasC,character,character,character,character,logical,list-method}
\alias{plGwas,RbedInfoC,character,character,character,character,logical,list-method}
\alias{plGwas,RbedInfoC,character,character,character,character,logical,missing-method}
\alias{plGwas,RbedInfoC,character,character,character,character,missing,list-method}
\alias{plGwas,RbedInfoC,character,character,character,character,missing,missing-method}
\alias{plGwas,RbedInfoC,character,character,missing,character,missing,missing-method}
\title{Constructor for PlGwasC class}
\usage{
plGwas(pl_gwas, pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{PlGwasC,character,character,character,character,logical,list}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{RbedInfoC,character,character,character,character,logical,list}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{RbedInfoC,character,character,character,character,missing,missing}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{RbedInfoC,character,character,character,character,missing,list}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{RbedInfoC,character,character,character,character,logical,missing}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)


  \S4method{plGwas}{RbedInfoC,character,character,missing,character,missing,missing}(pl_gwas,
  pheno, pheno_name, covar_name, gwas_tag, assoc, opts)
}
\arguments{
\item{pl_gwas}{PlGwasC or PlInfoC object}

\item{pheno}{character. Phenotype file}

\item{pheno_name}{character. Phenotype names.}

\item{covar_name}{character. Covariate names.}

\item{gwas_tag}{character. Tag for this GWAS.}

\item{assoc}{logical. Whether use the "--assoc" option for PLINK.}

\item{opts}{list. Options to be passed to PLINK.}
}
\value{
PlGwasC object
}
\description{
Constructor for PlGwasC class
}
\examples{
\dontrun{
gwas_tag = "mmp13_page_sex_age"
rbed_info = rbedInfo(bedstem = "mmp13")
pl_gwas = plGwas(rbed_info, 
		pheno = "mmp13.phe",
		pheno_name = "Page", 
		covar_name = "Sex,Cage", 
		gwas_tag = gwas_tag)
runGwas(pl_gwas)
"mmp13_page_sex_age" \%in\% listGwasTags() == "TRUE"
gwas_out = readGwasOut(pl_gwas, rmGwasOut = FALSE)
colClasses(gwas_out) == c("integer", "character", "integer", 
    "character", "character", "integer", 
    "numeric", "numeric", "numeric")
}

}
\author{
Kaiyin Zhong, Fan Liu
}

