% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/sackin.index.R
\name{sackin.index}
\alias{sackin.index}
\title{Computes the Sackin balance index of a phylogenetic tree}
\usage{
sackin.index(tree, norm = FALSE)
}
\arguments{
\item{tree}{a single phylogenetic tree. It can be entered as a string in Newick format, as a 'phylo' object (\code{ape} package) or as an 'igraph' object (\code{igraph} package).}

\item{norm}{a logical variable that indicates whether the index should be normalized or not.}
}
\value{
numeric value.
}
\description{
Given a phylogenetic tree, computes the Sackin balance index of that phylogenetic tree.
}
\details{
The Sackin's index is computed as the sum of the number of ancestors for each leave of the tree.
}
\examples{
# Computation of the Sackin balance index of trees 
# entered in newick format:
sackin.index("(1,2,3,4,5);")
sackin.index("(1,(2,(3,(4,5))));")

# Computation of the Sackin balance index of trees 
# entered as a phylo object:
require(ape)
random.tree = rtree(5,rooted=TRUE)
sackin.index(random.tree)

# Computation of the Sackin balance index of a tree
# entered as a igraph object. The tree is randomly 
# generated from all trees with 5 leaves following
# the alpha-gamma model with alpha=0.5 and gamma=0.3.
a.g.tree = a.g.model(5,0.5,0.3)
sackin.index(a.g.tree)

#All of them can be normalized (values between 0 and 1)
sackin.index("(1,2,3,4,5);",norm=TRUE)
sackin.index("(1,(2,(3,(4,5))));",norm=TRUE)
sackin.index(random.tree,norm=TRUE)
sackin.index(a.g.tree,norm=TRUE)

}
\references{
M. J. Sackin, "Good" and  "bad" phenograms. \emph{Sys. Zool}, \bold{21} (1972), 225-226.
}
\author{
Lucia Rotger
}
