% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Poisson_Regression.R
\name{RunPoissonRegression_STRATA}
\alias{RunPoissonRegression_STRATA}
\title{Performs poisson regression with strata effect
\code{RunPoissonRegression_STRATA} uses user provided data, time/event columns, vectors specifying the model, and options to control the convergence and starting positions}
\usage{
RunPoissonRegression_STRATA(
  df,
  pyr,
  event0,
  names,
  Term_n,
  tform,
  keep_constant,
  a_n,
  modelform,
  fir,
  der_iden,
  control,
  Strat_Cols
)
}
\arguments{
\item{df}{a data.table containing the columns of interest}

\item{pyr}{column used for person-years per row}

\item{event0}{column used for event status}

\item{names}{columns for elements of the model, used to identify data columns}

\item{Term_n}{term numbers for each element of the model}

\item{tform}{list of string function identifiers, used for linear/step}

\item{keep_constant}{binary values to denote which parameters to change}

\item{a_n}{list of initial parameter values, used to determine number of parameters}

\item{modelform}{string specifying the model type}

\item{fir}{term number for the initial term, used for models of the form T0*f(Ti) in which the order matters}

\item{der_iden}{number for the subterm to test derivative at, only used for testing runs with a single varying parameter}

\item{control}{list of parameters controlling the convergence}

\item{Strat_Cols}{column to stratify by}
}
\value{
returns a list of the final results
}
\description{
Performs poisson regression with strata effect
\code{RunPoissonRegression_STRATA} uses user provided data, time/event columns, vectors specifying the model, and options to control the convergence and starting positions
}
\examples{
library(data.table)
## basic example code reproduced from the starting-description vignette

df <- data.table("UserID"=c(112, 114, 213, 214, 115, 116, 117),
           "Starting_Age"=c(18,  20,  18,  19,  21,  20,  18),
             "Ending_Age"=c(30,  45,  57,  47,  36,  60,  55),
          "Cancer_Status"=c(0,   0,   1,   0,   1,   0,   0),
                      "a"=c(0,   1,   1,   0,   1,   0,   1),
                      "b"=c(1,   1.1, 2.1, 2,   0.1, 1,   0.2),
                      "c"=c(10,  11,  10,  11,  12,  9,   11),
                      "d"=c(0,   0,   0,   1,   1,   1,   1),
                      "e"=c(0,   0,   0,   0,   1,   0,   1))
# For the interval case
df$pyr <- df$Ending_Age - df$Starting_Age
pyr <- 'pyr'
event <- "Cancer_Status"
names <- c('a','b','c','d')
Term_n <- c(0,1,1,2)
tform <- c("loglin","lin","lin","plin")
modelform <- "M"
fir <- 0
a_n <- c(0.1, 0.1, 0.1, 0.1)

keep_constant <- c(0,0,0,0)
der_iden <- 0

control <- list("Ncores"=2,'lr' = 0.75,'maxiter' = 5,'halfmax' = 5,
             'epsilon' = 1e-3,'dbeta_max' = 0.5, 'deriv_epsilon' = 1e-3,
             'abs_max'=1.0,'change_all'=TRUE,'dose_abs_max'=100.0,
             'verbose'=FALSE, 'double_step'=1)
Strat_Col <- c("e")
e <- RunPoissonRegression_STRATA(df, pyr, event, names, Term_n, tform, keep_constant,
     a_n, modelform, fir, der_iden, control, Strat_Col)

}
