% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Help_Func.R
\name{model_gen}
\alias{model_gen}
\title{Model Generations}
\usage{
model_gen(
  y,
  type = "lm",
  batch = NULL,
  covariates = NULL,
  interaction = NULL,
  random = NULL,
  smooth = NULL,
  df
)
}
\arguments{
\item{y}{Dependent variable in the model.}

\item{type}{A model function name that is used or to be used in the ComBatFamily Package (eg: "lmer", "lm", "gam").}

\item{batch}{Name of batch variable (often equivalent to site or scanner).}

\item{covariates}{Name of covariates supplied to \code{model}.}

\item{interaction}{Expression of interaction terms supplied to \code{model} (eg: "age:diagnosis").}

\item{random}{Variable name of a random effect in linear mixed effect model.}

\item{smooth}{Variable name that requires a smooth function.}

\item{df}{Dataset to be harmonized.}
}
\value{
A regression model object to be used for batch effect diagnostics and the post-harmonization stage.
}
\description{
Generate appropriate regression models based on the model type and formula
}
\examples{
model_gen(y = "thickness.left.caudal.anterior.cingulate", type = "lm",
batch = "manufac", covariates = c("AGE", "SEX"), df = adni)

}
