% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Harmonization.R
\name{predict.comfam}
\alias{predict.comfam}
\title{Apply Harmonization to New Data}
\usage{
\method{predict}{comfam}(
  object,
  newdata,
  newbat,
  newcovar = NULL,
  robust.LS = FALSE,
  eb = TRUE,
  ...
)
}
\arguments{
\item{object}{Object of class \code{comfam}, typically output of the harmonization
function in this package.}

\item{newdata}{\emph{n x p} data frame or matrix of new observations where
\emph{p} is the number of features and \emph{n} is the number of subjects.
The features must match the original \code{data} used in \code{object}}

\item{newbat}{Factor indicating new batch (often equivalent to site or scanner)}

\item{newcovar}{Data frame or matrix of new covariates supplied to \code{model}.
Must contain all variables specified in the original \code{formula} used in
\code{object}.}

\item{robust.LS}{If \code{TRUE}, uses robust location and scale estimators
for new batch effect estimates Currently uses median and biweight
midvariance}

\item{eb}{If \code{TRUE}, uses ComBat model with empirical Bayes for new batches}

\item{...}{Additional arguments to \code{predict} for the class of \code{model} (e.g.
\code{predict.lm} for ComBat)}
}
\value{
\code{predict.comfam} returns a list containing the following components:
\item{dat.combat}{New harmonized data as a matrix with same dimensions as \code{newdata}}
\item{batch.info}{New batch information, including reference batch if specified}
\item{fits}{List of model fits from regression step, forwarded from \code{object}}
\item{estimates}{List of estimates from standardization and batch effect correction, including new batches if relevant}
}
\description{
Using parameters estimated via \code{comfam}, apply harmonization on new data.
\code{predict.comfam} will estimate new batch adjustments if new batches are
specified. For batches with existing estimates, the estimates from \code{object}
are used. Harmonization targets are the same as \code{object} (e.g. \code{ref.batch}
from \code{object} if specified).
}
\details{
\strong{Note:} The function currently does not support models of class \code{lmer}
(e.g., from \link[lme4]{lmer}).
}
\examples{
com_out <- comfam(iris[1:75,1:2], iris$Species[1:75])

# out-of-sample with new batch
out_pred <- predict(com_out, iris[76:150,1:2], iris$Species[76:150])

# in-sample
in_pred <- predict(com_out, iris[1:25,1:2], iris$Species[1:25])
max(in_pred$dat.combat - com_out$dat.combat[1:25,])
}
