\name{selfcontained.test}
\alias{selfcontained.test}
\alias{selfcontained.test}
\docType{package}
\title{
selfcontained.test: combine a vector of correlated p-values

}
\description{
we are interested to test whether H0: pvalue is uniform vs. Ha: pvalue is not uniform.                                        

}
\details{
\tabular{ll}{
Package: \tab CombinePValue\cr
Type: \tab Package\cr
Version: \tab 1.0\cr
Date: \tab 2014-10-29\cr
License: \tab GPL-3 \cr
}

Parameters: 

pvalue: this is a vector. For instance, pvalue=c(0.01,0.04,0.06,0.15,0.17).

weight: This is weight for p-values. Weight should be positive and weight is a vector with the same length as pvalue. For instance, weight=c(2,4,5,2,3).

If you do not have weight for p-values, simply set weight = NA. Default sets weight=2 for each p-value. This equals to Fisher's method with correlation. Traditional Fisher's method is based on independent assumptions. In this code, all tests (including Fisher's method), take correlations into account.

p_permu: this is p-value matrix. One can use bootstrap method to randomly select samples or use permutation method to randomly shuffle phenotype (outcome variable) 200 times. Feel free to change 200 to other numbers. Bootstrapping of samples or permutation of phenotype allows us to generate samples of pvalue. Thus we can incorporate correlation among these pvalues in p_permu matrix. Every time after you perform bootstrap or permutation, you need to rerun your original analysis to generate a new vector of pvalue. Put pvalue vector in the column of p_permu. For instance, if you bootstrap samples or shuffle phenotype 200 times and pvalue is a vector of length 5, then p_permu is a matrix with 5 rows x 200 columns.


}
\author{
Hongying Dai

Maintainer: Hongying Dai <hdai@cmh.edu>

}
\references{
Citation:  Dai et al. A Modified Generalized Fisher Method for Combining Probabilities from Dependent Tests. Frontiers in Genetics. 2014, 20
}

\keyword{ package }
\seealso{
d.web.umkc.edu/hdai

CombinePValue

competitive.test

}
\examples{
#p_permu is generated by bootstrap or permutation to estimate correlations among p values.   

a<-matrix(c(0.02,0.06,0.07,0.01,0.02,0.09,0.01,0.01,0.10,0.12,0.14,0.07,0.09,0.10,0.15),nrow=3) 
selfcontained.test(pvalue=c(0.01,0.04,0.06),weight=NA,p_permu=a) 

#The traditional Fisher's test assuming p-values are independent. 

selfcontained.test(pvalue=c(0.01,0.04,0.06),weight=NA,p_permu=NA) 

#Generalized Fisher method with a weight function.  If p_permu=NA, then p-values are independent.

selfcontained.test(pvalue=c(0.01,0.04,0.06),weight=c(7,2,1.5),p_permu=NA) 
 
}
