/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking;

import java.awt.Dimension;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.List;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.SwingUtilities;
import net.infonode.docking.DockingWindow;
import net.infonode.docking.FocusManager;
import net.infonode.docking.OperationAbortedException;
import net.infonode.docking.RootWindow;
import net.infonode.docking.TabWindowMover;
import net.infonode.docking.View;
import net.infonode.docking.WindowDecoder;
import net.infonode.docking.WindowTab;
import net.infonode.docking.drop.InsertTabDropInfo;
import net.infonode.docking.internal.ReadContext;
import net.infonode.docking.internal.WindowAncestors;
import net.infonode.docking.internal.WriteContext;
import net.infonode.docking.internalutil.DropAction;
import net.infonode.docking.model.AbstractTabWindowItem;
import net.infonode.docking.model.ViewReader;
import net.infonode.docking.model.ViewWriter;
import net.infonode.docking.model.WindowItem;
import net.infonode.docking.properties.TabWindowProperties;
import net.infonode.docking.properties.WindowTabProperties;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.Tab;
import net.infonode.tabbedpanel.TabAdapter;
import net.infonode.tabbedpanel.TabContentPanel;
import net.infonode.tabbedpanel.TabEvent;
import net.infonode.tabbedpanel.TabRemovedEvent;
import net.infonode.tabbedpanel.TabStateChangedEvent;
import net.infonode.tabbedpanel.TabbedPanel;
import net.infonode.util.ChangeNotifyList;

public abstract class AbstractTabWindow
extends DockingWindow {
    private static int MINIMUM_SIZE = 7;
    private final DropAction dropAction = new DropAction(){

        public boolean showTitle() {
            return false;
        }

        public void execute(DockingWindow dockingWindow, MouseEvent mouseEvent) {
            if (dockingWindow.getWindowParent() == AbstractTabWindow.this) {
                AbstractTabWindow.this.updateWindowItem(dockingWindow);
            } else {
                int n = AbstractTabWindow.this.tabbedPanel.getTabIndex(AbstractTabWindow.this.dragTab);
                AbstractTabWindow.this.stopDrag();
                try {
                    dockingWindow.beforeDrop(AbstractTabWindow.this);
                    if (mouseEvent.isShiftDown()) {
                        AbstractTabWindow.this.addTabNoSelect(dockingWindow, n);
                    } else {
                        AbstractTabWindow.this.addTab(dockingWindow, n);
                    }
                }
                catch (OperationAbortedException operationAbortedException) {
                    // empty catch block
                }
            }
        }

        public void clear(DockingWindow dockingWindow, DropAction dropAction) {
            if (dropAction != this) {
                if (dockingWindow.getWindowParent() == AbstractTabWindow.this) {
                    WindowTab windowTab = dockingWindow.getTab();
                    boolean bl = windowTab.isSelected();
                    AbstractTabWindow.this.tabbedPanel.removeTab(windowTab);
                    AbstractTabWindow.this.tabbedPanel.insertTab((Tab)windowTab, AbstractTabWindow.this.draggedTabIndex);
                    if (bl) {
                        windowTab.setSelected(true);
                    }
                } else {
                    AbstractTabWindow.this.stopDrag();
                }
            }
        }
    };
    private TabbedPanel tabbedPanel;
    private WindowTab dragTab;
    private int ignoreSelected;
    private int draggedTabIndex;
    private List tabAreaComponents;

    public abstract TabWindowProperties getTabWindowProperties();

    protected AbstractTabWindow(boolean bl, WindowItem windowItem) {
        super(windowItem);
        if (bl) {
            TabContentPanel tabContentPanel = new TabContentPanel(){

                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return new Dimension(0, 0);
                }
            };
            this.tabbedPanel = new TabbedPanel(tabContentPanel, true){

                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return AbstractTabWindow.this.getTabbedPanelMinimumSize(super.getMinimumSize());
                }
            };
            tabContentPanel.setTabbedPanel(this.tabbedPanel);
        } else {
            this.tabbedPanel = new TabbedPanel(null){

                public Dimension getMinimumSize() {
                    if (AbstractTabWindow.this.getTabWindowProperties().getRespectChildWindowMinimumSize()) {
                        return super.getMinimumSize();
                    }
                    return AbstractTabWindow.this.getTabbedPanelMinimumSize(super.getMinimumSize());
                }
            };
        }
        this.tabbedPanel.addTabListener(new TabWindowMover(this, this.tabbedPanel));
        this.setComponent(this.tabbedPanel);
        this.getTabbedPanel().addTabListener(new TabAdapter(){

            public void tabAdded(TabEvent tabEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$500(this.this$1).updateButtonVisibility();
                    }
                });
            }

            public void tabRemoved(TabRemovedEvent tabRemovedEvent) {
                SwingUtilities.invokeLater(new Runnable(this){
                    private final /* synthetic */ 5 this$1;
                    {
                        this.this$1 = var1_1;
                    }

                    public void run() {
                        5.access$500(this.this$1).updateButtonVisibility();
                    }
                });
            }

            public void tabSelected(TabStateChangedEvent tabStateChangedEvent) {
                AbstractTabWindow.this.tabSelected((WindowTab)tabStateChangedEvent.getTab());
                DockingWindow dockingWindow = AbstractTabWindow.this.getSelectedWindow();
                if (!AbstractTabWindow.this.getIgnoreSelected() && dockingWindow != null) {
                    dockingWindow.fireWindowShown(dockingWindow);
                }
            }

            public void tabDeselected(TabStateChangedEvent tabStateChangedEvent) {
                WindowTab windowTab = (WindowTab)tabStateChangedEvent.getTab();
                if (windowTab != null && !AbstractTabWindow.this.getIgnoreSelected()) {
                    windowTab.getWindow().fireWindowHidden(windowTab.getWindow());
                }
            }

            public void tabMoved(TabEvent tabEvent) {
                if (!AbstractTabWindow.this.getIgnoreSelected()) {
                    AbstractTabWindow.this.fireTitleChanged();
                }
            }

            static /* synthetic */ AbstractTabWindow access$500(5 var0) {
                return var0.AbstractTabWindow.this;
            }
        });
    }

    protected void initMouseListener() {
        this.getTabbedPanel().addMouseListener(new MouseAdapter(){

            public void mousePressed(MouseEvent mouseEvent) {
                if (mouseEvent.isPopupTrigger()) {
                    AbstractTabWindow.this.showPopupMenu(mouseEvent);
                }
            }

            public void mouseReleased(MouseEvent mouseEvent) {
                this.mousePressed(mouseEvent);
            }
        });
    }

    private Dimension getTabbedPanelMinimumSize(Dimension dimension) {
        if (this.tabbedPanel.getProperties().getTabAreaOrientation().isHorizontal()) {
            return new Dimension(dimension.width, MINIMUM_SIZE);
        }
        return new Dimension(MINIMUM_SIZE, dimension.height);
    }

    public final List getCustomTabAreaComponents() {
        if (this.tabAreaComponents == null) {
            this.tabAreaComponents = new ChangeNotifyList(){

                protected void changed() {
                    AbstractTabWindow.this.updateTabAreaComponents();
                }
            };
        }
        return this.tabAreaComponents;
    }

    public DockingWindow getSelectedWindow() {
        WindowTab windowTab = (WindowTab)this.tabbedPanel.getSelectedTab();
        return windowTab == null ? null : windowTab.getWindow();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setSelectedTab(int n) {
        this.beginIgnoreSelected();
        try {
            Tab tab = n == -1 ? null : this.tabbedPanel.getTabAt(n);
            Tab tab2 = this.tabbedPanel.getSelectedTab();
            if (tab != tab2) {
                this.tabbedPanel.setSelectedTab(tab);
                this.fireTitleChanged();
                if (tab2 != null) {
                    ((WindowTab)tab2).getWindow().fireWindowHidden(((WindowTab)tab2).getWindow());
                }
                if (tab != null) {
                    ((WindowTab)tab).getWindow().fireWindowShown(((WindowTab)tab).getWindow());
                }
            }
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addTab(DockingWindow dockingWindow) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            this.addTab(dockingWindow, this.tabbedPanel.getTabCount());
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int addTab(DockingWindow dockingWindow, int n) {
        PropertyMapManager.getInstance().beginBatch();
        try {
            int n2 = this.addTabNoSelect(dockingWindow, n);
            return n2;
        }
        finally {
            PropertyMapManager.getInstance().endBatch();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected int addTabNoSelect(DockingWindow dockingWindow, int n) {
        WindowAncestors windowAncestors = dockingWindow.storeAncestors();
        AbstractTabWindow.beginOptimize(dockingWindow.getWindowParent());
        this.beginIgnoreSelected();
        try {
            Tab tab = n >= this.tabbedPanel.getTabCount() ? null : this.tabbedPanel.getTabAt(n);
            DockingWindow dockingWindow2 = dockingWindow.getContentWindow(this);
            dockingWindow2.detach();
            this.updateTab(dockingWindow2);
            WindowTab windowTab = dockingWindow2.getTab();
            int n2 = tab == null ? this.tabbedPanel.getTabCount() : this.tabbedPanel.getTabIndex(tab);
            this.tabbedPanel.insertTab((Tab)windowTab, n2);
            this.addWindow(dockingWindow2);
            dockingWindow.notifyListeners(windowAncestors);
            int n3 = n2;
            return n3;
        }
        finally {
            this.endIgnoreSelected();
            AbstractTabWindow.endOptimize();
        }
    }

    protected boolean isChildShowingInRootWindow(DockingWindow dockingWindow) {
        return super.isChildShowingInRootWindow(dockingWindow) && dockingWindow == this.getSelectedWindow();
    }

    protected void showChildWindow(DockingWindow dockingWindow) {
        this.setSelectedTab(this.getChildWindowIndex(dockingWindow));
        super.showChildWindow(dockingWindow);
    }

    protected boolean childInsideTab() {
        return true;
    }

    protected void setTabWindowProperties(TabWindowProperties tabWindowProperties) {
        this.getTabbedPanel().getProperties().addSuperObject(tabWindowProperties.getTabbedPanelProperties());
    }

    protected void clearFocus(View view) {
        if (this.getSelectedWindow() != null) {
            this.getSelectedWindow().clearFocus(view);
        }
    }

    protected DockingWindow getPreferredFocusChild() {
        return this.getSelectedWindow() == null ? super.getPreferredFocusChild() : this.getSelectedWindow();
    }

    protected void clearChildrenFocus(DockingWindow dockingWindow, View view) {
        if (this.getSelectedWindow() != dockingWindow) {
            this.clearFocus(view);
        }
    }

    protected int getTabAreaComponentCount() {
        return 0;
    }

    protected void updateTabAreaComponents() {
        int n = this.tabAreaComponents == null ? 0 : this.tabAreaComponents.size();
        JComponent[] jComponentArray = new JComponent[n + this.getTabAreaComponentCount()];
        if (this.tabAreaComponents != null) {
            this.tabAreaComponents.toArray(jComponentArray);
        }
        this.getTabAreaComponents(n, jComponentArray);
        this.getTabbedPanel().setTabAreaComponents(jComponentArray);
    }

    protected void getTabAreaComponents(int n, JComponent[] jComponentArray) {
    }

    protected final boolean getIgnoreSelected() {
        return this.ignoreSelected > 0;
    }

    protected void tabSelected(WindowTab windowTab) {
        RootWindow rootWindow;
        if (!this.getIgnoreSelected() && windowTab != null && (rootWindow = this.getRootWindow()) != null) {
            windowTab.setFocused(true);
            rootWindow.addFocusedWindow(windowTab.getWindow());
            FocusManager.focusWindow(windowTab.getWindow());
        }
        if (!this.getIgnoreSelected()) {
            this.fireTitleChanged();
        }
    }

    protected TabbedPanel getTabbedPanel() {
        return this.tabbedPanel;
    }

    public DockingWindow getChildWindow(int n) {
        return ((WindowTab)this.tabbedPanel.getTabAt(n)).getWindow();
    }

    protected DockingWindow getLocationWindow() {
        return this.tabbedPanel.getTabCount() == 1 ? this.getChildWindow(0) : this;
    }

    public int getChildWindowCount() {
        return this.tabbedPanel.getTabCount();
    }

    public Icon getIcon() {
        DockingWindow dockingWindow = this.getSelectedWindow();
        return dockingWindow != null ? dockingWindow.getIcon() : (this.getChildWindowCount() > 0 ? this.getChildWindow(0).getIcon() : null);
    }

    private void updateTab(DockingWindow dockingWindow) {
        dockingWindow.getTab().setProperties(this.getTabProperties(dockingWindow));
    }

    private WindowTabProperties getTabProperties(DockingWindow dockingWindow) {
        WindowTabProperties windowTabProperties = new WindowTabProperties(this.getTabWindowProperties().getTabProperties());
        windowTabProperties.addSuperObject(dockingWindow.getWindowProperties().getTabProperties());
        return windowTabProperties;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doReplace(DockingWindow dockingWindow, DockingWindow dockingWindow2) {
        this.beginIgnoreSelected();
        try {
            WindowTab windowTab = dockingWindow.getTab();
            int n = this.tabbedPanel.getTabIndex(windowTab);
            boolean bl = windowTab.isSelected();
            this.tabbedPanel.removeTab(windowTab);
            this.tabbedPanel.insertTab((Tab)dockingWindow2.getTab(), n);
            if (bl) {
                this.tabbedPanel.setSelectedTab(dockingWindow2.getTab());
            }
            this.updateTab(dockingWindow2);
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doRemoveWindow(DockingWindow dockingWindow) {
        this.beginIgnoreSelected();
        try {
            WindowTab windowTab = dockingWindow.getTab();
            windowTab.unsetProperties();
            this.tabbedPanel.removeTab(windowTab);
        }
        finally {
            this.endIgnoreSelected();
        }
    }

    private void beginIgnoreSelected() {
        ++this.ignoreSelected;
    }

    private void endIgnoreSelected() {
        --this.ignoreSelected;
    }

    protected boolean isInsideTabArea(Point point) {
        return this.tabbedPanel.tabAreaContainsPoint(point);
    }

    protected DropAction acceptInteriorDrop(Point point, DockingWindow dockingWindow) {
        if (this.getChildWindowCount() == 1 && dockingWindow == this.getChildWindow(0) && this.dragTab == null) {
            return null;
        }
        Point point2 = SwingUtilities.convertPoint(this, point, this.tabbedPanel);
        if ((this.getRootWindow().getRootWindowProperties().getRecursiveTabsEnabled() || dockingWindow.getChildWindowCount() <= 1) && this.isInsideTabArea(point2)) {
            this.getRootWindow().setDragRectangle(null);
            if (dockingWindow.getWindowParent() == this) {
                this.tabbedPanel.moveTab(dockingWindow.getTab(), point2);
            } else {
                if (!this.getInsertTabDropFilter().acceptDrop(new InsertTabDropInfo(dockingWindow, this, point))) {
                    return null;
                }
                if (this.dragTab == null) {
                    this.dragTab = this.createGhostTab(dockingWindow);
                    this.tabbedPanel.insertTab((Tab)this.dragTab, point2);
                } else {
                    this.tabbedPanel.moveTab(this.dragTab, point2);
                }
            }
            return this.dropAction;
        }
        return null;
    }

    WindowTab createGhostTab(DockingWindow dockingWindow) {
        WindowTab windowTab = new WindowTab(dockingWindow, true);
        windowTab.setProperties(this.getTabProperties(dockingWindow));
        return windowTab;
    }

    private void stopDrag() {
        if (this.dragTab != null) {
            this.tabbedPanel.removeTab(this.dragTab);
            this.dragTab = null;
        }
    }

    protected boolean showsWindowTitle() {
        return true;
    }

    protected DockingWindow oldRead(ObjectInputStream objectInputStream, ReadContext readContext) throws IOException {
        int n = objectInputStream.readInt();
        int n2 = objectInputStream.readInt();
        while (this.getChildWindowCount() > 0) {
            this.removeChildWindow(this.getChildWindow(0));
        }
        for (int i = 0; i < n; ++i) {
            DockingWindow dockingWindow = WindowDecoder.decodeWindow(objectInputStream, readContext);
            if (dockingWindow != null) {
                this.addTab(dockingWindow);
                continue;
            }
            if (i >= n2) continue;
            --n2;
        }
        super.oldRead(objectInputStream, readContext);
        if (this.tabbedPanel.getTabCount() > 0) {
            if (n2 >= 0) {
                this.setSelectedTab(Math.min(this.tabbedPanel.getTabCount() - 1, n2));
            }
            return this;
        }
        return null;
    }

    protected void write(ObjectOutputStream objectOutputStream, WriteContext writeContext, ViewWriter viewWriter) throws IOException {
        objectOutputStream.writeInt(this.getChildWindowCount());
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            this.getChildWindow(i).write(objectOutputStream, writeContext, viewWriter);
        }
    }

    protected DockingWindow newRead(ObjectInputStream objectInputStream, ReadContext readContext, ViewReader viewReader) throws IOException {
        int n = objectInputStream.readInt();
        while (this.getChildWindowCount() > 0) {
            this.removeChildWindow(this.getChildWindow(0));
        }
        for (int i = 0; i < n; ++i) {
            DockingWindow dockingWindow = WindowDecoder.decodeWindow(objectInputStream, readContext, viewReader);
            if (dockingWindow == null) continue;
            this.addTab(dockingWindow);
        }
        this.updateSelectedTab();
        return this.getChildWindowCount() > 0 ? this : null;
    }

    protected void updateSelectedTab() {
        WindowItem windowItem = ((AbstractTabWindowItem)this.getWindowItem()).getSelectedItem();
        for (int i = 0; i < this.getChildWindowCount(); ++i) {
            if (!this.getChildWindow(i).getWindowItem().hasAncestor(windowItem)) continue;
            this.setSelectedTab(i);
            return;
        }
    }

    void setDraggedTabIndex(int n) {
        this.draggedTabIndex = n;
    }

    void removeWindowComponent(DockingWindow dockingWindow) {
        dockingWindow.getTab().setContentComponent(null);
    }

    void restoreWindowComponent(DockingWindow dockingWindow) {
        dockingWindow.getTab().setContentComponent(dockingWindow);
    }
}

