/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.internal;

import java.awt.Dimension;
import java.awt.Insets;
import java.awt.event.MouseEvent;
import java.util.List;
import java.util.Map;
import javax.swing.AbstractButton;
import javax.swing.JComponent;
import javax.swing.JLabel;
import net.infonode.docking.View;
import net.infonode.docking.internalutil.ButtonInfo;
import net.infonode.docking.internalutil.CloseButtonInfo;
import net.infonode.docking.internalutil.DockButtonInfo;
import net.infonode.docking.internalutil.InternalDockingUtil;
import net.infonode.docking.internalutil.MaximizeButtonInfo;
import net.infonode.docking.internalutil.MinimizeButtonInfo;
import net.infonode.docking.internalutil.RestoreButtonInfo;
import net.infonode.docking.internalutil.UndockButtonInfo;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.docking.properties.ViewTitleBarStateProperties;
import net.infonode.gui.ContentTitleBar;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.hover.hoverable.HoverManager;
import net.infonode.properties.gui.InternalPropertiesUtil;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapListener;
import net.infonode.properties.propertymap.PropertyMapTreeListener;
import net.infonode.properties.propertymap.PropertyMapWeakListenerManager;

public class ViewTitleBar
extends ContentTitleBar {
    private static final ButtonInfo[] buttonInfos = new ButtonInfo[]{new UndockButtonInfo(ViewTitleBarStateProperties.UNDOCK_BUTTON_PROPERTIES), new DockButtonInfo(ViewTitleBarStateProperties.DOCK_BUTTON_PROPERTIES), new MinimizeButtonInfo(ViewTitleBarStateProperties.MINIMIZE_BUTTON_PROPERTIES), new MaximizeButtonInfo(ViewTitleBarStateProperties.MAXIMIZE_BUTTON_PROPERTIES), new RestoreButtonInfo(ViewTitleBarStateProperties.RESTORE_BUTTON_PROPERTIES), new CloseButtonInfo(ViewTitleBarStateProperties.CLOSE_BUTTON_PROPERTIES)};
    private DimensionProvider minimumSizeProvider;
    private View view;
    private AbstractButton[] buttons = new AbstractButton[buttonInfos.length];
    private List customBarComponents;
    private PropertyMapTreeListener propertiesListener = new PropertyMapTreeListener(){

        public void propertyValuesChanged(Map map) {
            ViewTitleBar.this.updateTitleBar(map);
        }
    };
    private PropertyMapListener buttonsListener = new PropertyMapListener(){

        public void propertyValuesChanged(PropertyMap propertyMap, Map map) {
            ViewTitleBar.this.updateViewButtons(null);
        }
    };
    private int pressedCount = 0;
    private boolean dragOutside = false;

    public ViewTitleBar(View view) {
        super(view);
        this.view = view;
        PropertyMapWeakListenerManager.addWeakTreeListener(view.getViewProperties().getViewTitleBarProperties().getMap(), this.propertiesListener);
        PropertyMapWeakListenerManager.addWeakListener(view.getWindowProperties().getMap(), this.buttonsListener);
        this.updateTitleBar(null);
        this.updateTitle();
        this.updateViewButtons(null);
        HoverManager.getInstance().addHoverable(this);
    }

    private void updateTitle() {
        ViewTitleBarStateProperties viewTitleBarStateProperties = this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties();
        this.getLabel().setText(viewTitleBarStateProperties.getTitleVisible() ? viewTitleBarStateProperties.getTitle() : null);
        this.getLabel().setIcon(viewTitleBarStateProperties.getIconVisible() ? viewTitleBarStateProperties.getIcon() : null);
    }

    private void updateTitleBar(Map map) {
        this.updateTitle();
        JLabel jLabel = this.getLabel();
        ViewTitleBarProperties viewTitleBarProperties = this.view.getViewProperties().getViewTitleBarProperties();
        ShapedPanelProperties shapedPanelProperties = viewTitleBarProperties.getNormalProperties().getShapedPanelProperties();
        ComponentProperties componentProperties = viewTitleBarProperties.getNormalProperties().getComponentProperties();
        this.updateViewButtons(map);
        if (map == null) {
            this.minimumSizeProvider = viewTitleBarProperties.getMinimumSizeProvider();
            componentProperties.applyTo(this);
            for (int i = 0; i < this.buttons.length; ++i) {
                if (this.buttons[i] == null) continue;
                this.buttons[i].setForeground(componentProperties.getForegroundColor());
                this.buttons[i].setBackground(shapedPanelProperties.getComponentPainter() != null ? null : componentProperties.getBackgroundColor());
            }
            jLabel.setForeground(componentProperties.getForegroundColor());
            jLabel.setFont(componentProperties.getFont());
            jLabel.setIconTextGap(viewTitleBarProperties.getNormalProperties().getIconTextGap());
            InternalPropertiesUtil.applyTo(shapedPanelProperties, this);
            this.setLayoutDirection(viewTitleBarProperties.getDirection());
            this.setHoverListener(viewTitleBarProperties.getHoverListener());
            this.setLabelAlignment(viewTitleBarProperties.getNormalProperties().getIconTextHorizontalAlignment());
        } else {
            Map map2 = (Map)map.get(viewTitleBarProperties.getMap());
            if (map2 != null) {
                if (map2.containsKey(ViewTitleBarProperties.MINIMUM_SIZE_PROVIDER)) {
                    this.minimumSizeProvider = viewTitleBarProperties.getMinimumSizeProvider();
                    this.revalidate();
                }
                if (map2.containsKey(ViewTitleBarProperties.DIRECTION)) {
                    this.setLayoutDirection(viewTitleBarProperties.getDirection());
                }
                if (map2.containsKey(ViewTitleBarProperties.HOVER_LISTENER)) {
                    this.setHoverListener(viewTitleBarProperties.getHoverListener());
                }
            }
            if ((map2 = (Map)map.get(viewTitleBarProperties.getNormalProperties().getMap())) != null) {
                if (map2.containsKey(ViewTitleBarStateProperties.ICON_TEXT_GAP)) {
                    jLabel.setIconTextGap(viewTitleBarProperties.getNormalProperties().getIconTextGap());
                }
                if (map2.containsKey(ViewTitleBarStateProperties.ICON_TEXT_HORIZONTAL_ALIGNMENT)) {
                    this.setLabelAlignment(viewTitleBarProperties.getNormalProperties().getIconTextHorizontalAlignment());
                }
            }
            if ((map2 = (Map)map.get(viewTitleBarProperties.getNormalProperties().getComponentProperties().getMap())) != null) {
                componentProperties.applyTo(this);
                jLabel.setForeground(componentProperties.getForegroundColor());
                jLabel.setFont(componentProperties.getFont());
                for (int i = 0; i < this.buttons.length; ++i) {
                    if (this.buttons[i] == null) continue;
                    this.buttons[i].setForeground(componentProperties.getForegroundColor());
                    this.buttons[i].setBackground(shapedPanelProperties.getComponentPainter() != null ? null : componentProperties.getBackgroundColor());
                }
            }
            if ((map2 = (Map)map.get(viewTitleBarProperties.getNormalProperties().getShapedPanelProperties().getMap())) != null) {
                InternalPropertiesUtil.applyTo(shapedPanelProperties, this);
            }
        }
    }

    public void updateViewButtons(Map map) {
        InternalDockingUtil.updateButtons(buttonInfos, this.buttons, null, this.view, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getMap(), map);
        if (this.shouldUpdateButtons()) {
            this.updateCustomBarComponents(this.customBarComponents);
        }
    }

    private boolean shouldUpdateButtons() {
        JComponent[] jComponentArray = this.getRightTitleComponents();
        if (jComponentArray == null || jComponentArray.length < this.buttons.length) {
            return true;
        }
        for (int i = 0; i < this.buttons.length; ++i) {
            if (jComponentArray[jComponentArray.length - i - 1] == this.buttons[i]) continue;
            return true;
        }
        return false;
    }

    public void updateCustomBarComponents(List list) {
        int n;
        this.customBarComponents = list;
        int n2 = list == null ? 0 : list.size();
        JComponent[] jComponentArray = new JComponent[n2 + this.buttons.length];
        Insets[] insetsArray = new Insets[jComponentArray.length];
        if (list != null) {
            for (n = 0; n < list.size(); ++n) {
                jComponentArray[n] = (JComponent)list.get(n);
                insetsArray[n] = n == 0 ? new Insets(0, 0, 0, 0) : new Insets(0, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getButtonSpacing(), 0, 0);
            }
        }
        for (n = 0; n < this.buttons.length; ++n) {
            int n3 = n2 + n;
            jComponentArray[n3] = this.buttons[n];
            insetsArray[n3] = n3 == 0 ? new Insets(0, 0, 0, 0) : new Insets(0, this.view.getViewProperties().getViewTitleBarProperties().getNormalProperties().getButtonSpacing(), 0, 0);
        }
        this.setRightTitleComponents(jComponentArray, insetsArray);
    }

    public void dispose() {
        HoverManager.getInstance().removeHoverable(this);
    }

    protected void processMouseEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 501) {
            ++this.pressedCount;
        }
        if (mouseEvent.getID() == 502) {
            --this.pressedCount;
            if (this.pressedCount <= 0) {
                this.dragOutside = false;
            }
        }
        super.processMouseEvent(mouseEvent);
    }

    protected void processMouseMotionEvent(MouseEvent mouseEvent) {
        if (mouseEvent.getID() == 506 && !this.dragOutside) {
            boolean bl = this.dragOutside = !this.contains(mouseEvent.getPoint());
            if (!this.dragOutside) {
                return;
            }
        }
        super.processMouseMotionEvent(mouseEvent);
    }

    public Dimension getMinimumSize() {
        if (this.minimumSizeProvider == null) {
            return super.getMinimumSize();
        }
        Dimension dimension = this.minimumSizeProvider.getDimension(this);
        return dimension == null ? super.getMinimumSize() : dimension;
    }

    public Dimension getPreferredSize() {
        Dimension dimension = this.minimumSizeProvider == null ? null : this.minimumSizeProvider.getDimension(this);
        Dimension dimension2 = super.getPreferredSize();
        if (dimension == null) {
            return dimension2;
        }
        return new Dimension(Math.max(dimension.width, dimension2.width), Math.max(dimension.height, dimension2.height));
    }
}

