/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.location;

import java.io.IOException;
import java.io.ObjectInputStream;
import net.infonode.docking.RootWindow;
import net.infonode.docking.location.NullLocation;
import net.infonode.docking.location.WindowLocation;
import net.infonode.docking.location.WindowRootLocation;
import net.infonode.docking.location.WindowSplitLocation;
import net.infonode.docking.location.WindowTabLocation;

public class LocationDecoder {
    public static final int NULL = 0;
    public static final int ROOT = 1;
    public static final int SPLIT = 2;
    public static final int TAB = 3;

    private LocationDecoder() {
    }

    public static WindowLocation decode(ObjectInputStream objectInputStream, RootWindow rootWindow) throws IOException {
        int n = objectInputStream.readInt();
        switch (n) {
            case 0: {
                return NullLocation.INSTANCE;
            }
            case 1: {
                return WindowRootLocation.decode(objectInputStream, rootWindow);
            }
            case 2: {
                return WindowSplitLocation.decode(objectInputStream, rootWindow);
            }
            case 3: {
                return WindowTabLocation.decode(objectInputStream, rootWindow);
            }
        }
        throw new IOException("Invalid location type!");
    }
}

