/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.docking.theme;

import java.awt.Color;
import java.awt.Component;
import java.awt.Graphics;
import java.awt.Insets;
import javax.swing.border.Border;
import net.infonode.docking.properties.RootWindowProperties;
import net.infonode.docking.properties.ViewTitleBarProperties;
import net.infonode.docking.properties.WindowBarProperties;
import net.infonode.docking.theme.DockingWindowsTheme;
import net.infonode.docking.theme.internal.laftheme.TitleBarUI;
import net.infonode.docking.theme.internal.laftheme.TitleBarUIListener;
import net.infonode.gui.InsetsUtil;
import net.infonode.gui.colorprovider.BackgroundColorProvider;
import net.infonode.gui.componentpainter.ComponentPainter;
import net.infonode.gui.componentpainter.CompoundComponentPainter;
import net.infonode.gui.componentpainter.SolidColorComponentPainter;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.tabbedpanel.TabbedUtils;
import net.infonode.tabbedpanel.theme.LookAndFeelTheme;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.util.Direction;

public class LookAndFeelDockingTheme
extends DockingWindowsTheme {
    private static LookAndFeelTheme tpTheme;
    private static RootWindowProperties rootProps;
    private RootWindowProperties themeRootProps = new RootWindowProperties();
    private static TitleBarUI titleBarUI;
    private static int themeCounter;
    private boolean disposed = false;

    public LookAndFeelDockingTheme() {
        if (themeCounter == 0) {
            tpTheme = new LookAndFeelTheme();
            titleBarUI = new TitleBarUI(new TitleBarUIListener(){

                public void updating() {
                }

                public void updated() {
                    LookAndFeelDockingTheme.this.initTheme(false);
                }
            }, false);
            titleBarUI.init();
            this.initTheme(true);
        }
        ++themeCounter;
        this.themeRootProps.addSuperObject(rootProps);
    }

    public String getName() {
        return "Look and Feel Theme";
    }

    public RootWindowProperties getRootWindowProperties() {
        return this.themeRootProps;
    }

    public void dispose() {
        if (!this.disposed) {
            this.disposed = true;
            if (--themeCounter == 0) {
                titleBarUI.dispose();
                PropertyMapManager.runBatch(new Runnable(){

                    public void run() {
                        rootProps.getTabWindowProperties().getTabbedPanelProperties().removeSuperObject(tpTheme.getTabbedPanelProperties());
                        rootProps.getTabWindowProperties().getTabProperties().getTitledTabProperties().removeSuperObject(tpTheme.getTitledTabProperties());
                        rootProps.getMap().clear(true);
                    }
                });
                tpTheme.dispose();
            }
        }
    }

    private void initTheme(final boolean bl) {
        PropertyMapManager.runBatch(new Runnable(){

            public void run() {
                if (bl) {
                    rootProps.getTabWindowProperties().getTabbedPanelProperties().addSuperObject(tpTheme.getTabbedPanelProperties());
                    rootProps.getTabWindowProperties().getTabProperties().getTitledTabProperties().addSuperObject(tpTheme.getTitledTabProperties());
                }
                rootProps.getMap().clear(true);
                Object object = rootProps.getWindowBarProperties();
                ((WindowBarProperties)object).getTabWindowProperties().getTabProperties().getTitledTabProperties().setSizePolicy(TitledTabSizePolicy.EQUAL_SIZE);
                ((WindowBarProperties)object).getComponentProperties().setBorder(null);
                Object object2 = tpTheme.getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().getBorder();
                Object object3 = tpTheme.getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().getComponentPainter();
                ((WindowBarProperties)object).getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getShapedPanelProperties().setOpaque(true).setComponentPainter(new CompoundComponentPainter(new SolidColorComponentPainter(BackgroundColorProvider.INSTANCE), (ComponentPainter)object3));
                ((WindowBarProperties)object).getTabWindowProperties().getTabbedPanelProperties().getTabAreaComponentsProperties().getComponentProperties().setBorder(null);
                ((WindowBarProperties)object).getTabWindowProperties().getTabbedPanelProperties().getContentPanelProperties().getComponentProperties().setBorder(new Border(this, (Border)object2){
                    private final /* synthetic */ Border val$contentBorder;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$contentBorder = border;
                    }

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                    }

                    public Insets getBorderInsets(Component component) {
                        Insets insets = (Insets)this.val$contentBorder.getBorderInsets(component).clone();
                        Direction direction = TabbedUtils.getParentTabbedPanelContentPanel(component).getTabbedPanel().getProperties().getTabAreaOrientation();
                        int n = InsetsUtil.maxInset(insets);
                        if (direction == Direction.UP) {
                            insets.bottom = Math.max(n, insets.bottom);
                        } else if (direction == Direction.DOWN) {
                            insets.top = Math.max(n, insets.top);
                        } else if (direction == Direction.LEFT) {
                            insets.right = Math.max(n, insets.right);
                        } else {
                            insets.left = Math.max(n, insets.left);
                        }
                        return insets;
                    }

                    public boolean isBorderOpaque() {
                        return false;
                    }
                }).setInsets(new Insets(0, 0, 0, 0)).setBackgroundColor(null);
                object = tpTheme.getBorderColor(Direction.UP);
                object2 = tpTheme.getBorderColor(Direction.LEFT);
                object3 = tpTheme.getBorderColor(Direction.DOWN);
                Color color = tpTheme.getBorderColor(Direction.RIGHT);
                Insets insets = new Insets(object == null ? 0 : 1, object2 == null ? 0 : 1, object3 == null ? 0 : 1, color == null ? 0 : 1);
                boolean bl2 = object != null && ((Color)object).getAlpha() == 255 || object2 != null && ((Color)object2).getAlpha() == 255 || object3 != null && ((Color)object3).getAlpha() == 255 || color != null && color.getAlpha() == 255;
                Border border = new Border(this, (Color)object, color, (Color)object3, (Color)object2, insets, bl2){
                    private final /* synthetic */ Color val$top;
                    private final /* synthetic */ Color val$right;
                    private final /* synthetic */ Color val$bottom;
                    private final /* synthetic */ Color val$left;
                    private final /* synthetic */ Insets val$borderInsets;
                    private final /* synthetic */ boolean val$borderOpaque;
                    private final /* synthetic */ 3 this$1;
                    {
                        this.this$1 = var1_1;
                        this.val$top = color;
                        this.val$right = color2;
                        this.val$bottom = color3;
                        this.val$left = color4;
                        this.val$borderInsets = insets;
                        this.val$borderOpaque = bl;
                    }

                    public void paintBorder(Component component, Graphics graphics, int n, int n2, int n3, int n4) {
                        if (this.val$top != null) {
                            graphics.setColor(this.val$top);
                            graphics.drawLine(n, n2, n + n3 - (this.val$right == null ? 1 : 2), n2);
                        }
                        if (this.val$right != null) {
                            graphics.setColor(this.val$right);
                            graphics.drawLine(n + n3 - 1, n2, n + n3 - 1, n2 + n4 - (this.val$bottom == null ? 1 : 2));
                        }
                        if (this.val$bottom != null) {
                            graphics.setColor(this.val$bottom);
                            graphics.drawLine(this.val$left == null ? n : n + 1, n2 + n4 - 1, n + n3 - 1, n2 + n4 - 1);
                        }
                        if (this.val$left != null) {
                            graphics.setColor(this.val$left);
                            graphics.drawLine(n, this.val$top == null ? n2 : n2 + 1, n, n2 + n4 - 1);
                        }
                    }

                    public Insets getBorderInsets(Component component) {
                        return this.val$borderInsets;
                    }

                    public boolean isBorderOpaque() {
                        return this.val$borderOpaque;
                    }
                };
                rootProps.getWindowAreaProperties().setInsets(new Insets(2, 2, 2, 2)).setBorder(border).setBackgroundColor(null);
                rootProps.getWindowAreaShapedPanelProperties().setComponentPainter(new SolidColorComponentPainter(BackgroundColorProvider.INSTANCE)).setOpaque(true);
                object = rootProps.getViewProperties().getViewTitleBarProperties();
                ((ViewTitleBarProperties)object).getNormalProperties().getShapedPanelProperties().setDirection(titleBarUI.getRenderingDirection());
                object2 = titleBarUI.getInactiveComponentPainter();
                if (object2 == null) {
                    ((ViewTitleBarProperties)object).getNormalProperties().getShapedPanelProperties().getMap().removeValue(ShapedPanelProperties.COMPONENT_PAINTER);
                } else {
                    ((ViewTitleBarProperties)object).getNormalProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)object2);
                }
                object3 = titleBarUI.getActiveComponentPainter();
                if (object3 == null) {
                    ((ViewTitleBarProperties)object).getFocusedProperties().getShapedPanelProperties().getMap().removeValue(ShapedPanelProperties.COMPONENT_PAINTER);
                } else {
                    ((ViewTitleBarProperties)object).getFocusedProperties().getShapedPanelProperties().setComponentPainter((ComponentPainter)object3);
                }
                ((ViewTitleBarProperties)object).setMinimumSizeProvider(titleBarUI.getSizeDimensionProvider()).getNormalProperties().setTitleVisible(!titleBarUI.isRenderingTitle()).setIconVisible(!titleBarUI.isRenderingIcon());
                ((ViewTitleBarProperties)object).getFocusedProperties().getComponentProperties().setInsets(titleBarUI.getInsets());
                ((ViewTitleBarProperties)object).getNormalProperties().getComponentProperties().setInsets(titleBarUI.getInsets());
                LookAndFeelDockingTheme.this.updateBackgroundColor(((ViewTitleBarProperties)object).getNormalProperties().getComponentProperties(), titleBarUI.getInactiveBackgroundColor());
                LookAndFeelDockingTheme.this.updateBackgroundColor(((ViewTitleBarProperties)object).getFocusedProperties().getComponentProperties(), titleBarUI.getActiveBackgroundColor());
                rootProps.setDragRectangleBorderWidth(3);
            }
        });
    }

    private void updateBackgroundColor(ComponentProperties componentProperties, Color color) {
        if (color == null) {
            componentProperties.getMap().removeValue(ComponentProperties.BACKGROUND_COLOR);
        } else {
            componentProperties.setBackgroundColor(color);
        }
    }

    static {
        rootProps = new RootWindowProperties();
        themeCounter = 0;
    }
}

