/*
 * Decompiled with CFR 0.152.
 */
package net.infonode.tabbedpanel.titledtab;

import javax.swing.border.CompoundBorder;
import net.infonode.gui.DimensionProvider;
import net.infonode.gui.DynamicUIManager;
import net.infonode.gui.DynamicUIManagerListener;
import net.infonode.gui.hover.HoverListener;
import net.infonode.properties.base.Property;
import net.infonode.properties.base.PropertyGroup;
import net.infonode.properties.gui.util.ComponentProperties;
import net.infonode.properties.gui.util.ShapedPanelProperties;
import net.infonode.properties.propertymap.PropertyMap;
import net.infonode.properties.propertymap.PropertyMapContainer;
import net.infonode.properties.propertymap.PropertyMapFactory;
import net.infonode.properties.propertymap.PropertyMapGroup;
import net.infonode.properties.propertymap.PropertyMapManager;
import net.infonode.properties.propertymap.PropertyMapProperty;
import net.infonode.properties.propertymap.PropertyMapValueHandler;
import net.infonode.properties.types.BooleanProperty;
import net.infonode.properties.types.DimensionProviderProperty;
import net.infonode.properties.types.HoverListenerProperty;
import net.infonode.properties.types.IntegerProperty;
import net.infonode.tabbedpanel.TabbedUIDefaults;
import net.infonode.tabbedpanel.border.TabAreaLineBorder;
import net.infonode.tabbedpanel.border.TabHighlightBorder;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabBorderSizePolicyProperty;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicy;
import net.infonode.tabbedpanel.titledtab.TitledTabSizePolicyProperty;
import net.infonode.tabbedpanel.titledtab.TitledTabStateProperties;
import net.infonode.util.Alignment;
import net.infonode.util.Direction;

public class TitledTabProperties
extends PropertyMapContainer {
    public static final PropertyMapGroup PROPERTIES;
    public static final BooleanProperty FOCUSABLE;
    public static final BooleanProperty FOCUS_MARKER_ENABLED;
    public static final PropertyMapProperty NORMAL_PROPERTIES;
    public static final PropertyMapProperty HIGHLIGHTED_PROPERTIES;
    public static final PropertyMapProperty DISABLED_PROPERTIES;
    public static final TitledTabSizePolicyProperty SIZE_POLICY;
    public static final TitledTabBorderSizePolicyProperty BORDER_SIZE_POLICY;
    public static final DimensionProviderProperty MINIMUM_SIZE_PROVIDER;
    public static final IntegerProperty HIGHLIGHTED_RAISED_AMOUNT;
    public static final HoverListenerProperty HOVER_LISTENER;
    public static final BooleanProperty ENABLED;
    private static final TitledTabProperties DEFAULT_VALUES;

    public TitledTabProperties() {
        super(PropertyMapFactory.create(PROPERTIES));
    }

    public TitledTabProperties(PropertyMap propertyMap) {
        super(propertyMap);
    }

    public TitledTabProperties(TitledTabProperties titledTabProperties) {
        super(PropertyMapFactory.create(titledTabProperties.getMap()));
    }

    public TitledTabProperties addSuperObject(TitledTabProperties titledTabProperties) {
        this.getMap().addSuperMap(titledTabProperties.getMap());
        return this;
    }

    public TitledTabProperties removeSuperObject() {
        this.getMap().removeSuperMap();
        return this;
    }

    public TitledTabProperties removeSuperObject(TitledTabProperties titledTabProperties) {
        this.getMap().removeSuperMap(titledTabProperties.getMap());
        return this;
    }

    public TitledTabProperties replaceSuperObject(TitledTabProperties titledTabProperties, TitledTabProperties titledTabProperties2) {
        this.getMap().replaceSuperMap(titledTabProperties.getMap(), titledTabProperties2.getMap());
        return this;
    }

    public static TitledTabProperties getDefaultProperties() {
        return new TitledTabProperties(DEFAULT_VALUES);
    }

    public TitledTabStateProperties getNormalProperties() {
        return new TitledTabStateProperties(NORMAL_PROPERTIES.get(this.getMap()));
    }

    public TitledTabStateProperties getHighlightedProperties() {
        return new TitledTabStateProperties(HIGHLIGHTED_PROPERTIES.get(this.getMap()));
    }

    public TitledTabStateProperties getDisabledProperties() {
        return new TitledTabStateProperties(DISABLED_PROPERTIES.get(this.getMap()));
    }

    public TitledTabProperties setFocusable(boolean bl) {
        FOCUSABLE.set(this.getMap(), bl);
        return this;
    }

    public boolean getFocusable() {
        return FOCUSABLE.get(this.getMap());
    }

    public TitledTabProperties setFocusMarkerEnabled(boolean bl) {
        FOCUS_MARKER_ENABLED.set(this.getMap(), bl);
        return this;
    }

    public boolean getFocusMarkerEnabled() {
        return FOCUS_MARKER_ENABLED.get(this.getMap());
    }

    public TitledTabProperties setSizePolicy(TitledTabSizePolicy titledTabSizePolicy) {
        SIZE_POLICY.set(this.getMap(), titledTabSizePolicy);
        return this;
    }

    public TitledTabSizePolicy getSizePolicy() {
        return SIZE_POLICY.get(this.getMap());
    }

    public TitledTabProperties setBorderSizePolicy(TitledTabBorderSizePolicy titledTabBorderSizePolicy) {
        BORDER_SIZE_POLICY.set(this.getMap(), titledTabBorderSizePolicy);
        return this;
    }

    public TitledTabBorderSizePolicy getBorderSizePolicy() {
        return BORDER_SIZE_POLICY.get(this.getMap());
    }

    public TitledTabProperties setMinimumSizeProvider(DimensionProvider dimensionProvider) {
        MINIMUM_SIZE_PROVIDER.set(this.getMap(), dimensionProvider);
        return this;
    }

    public DimensionProvider getMinimumSizeProvider() {
        return MINIMUM_SIZE_PROVIDER.get(this.getMap());
    }

    public TitledTabProperties setHighlightedRaised(int n) {
        HIGHLIGHTED_RAISED_AMOUNT.set(this.getMap(), n);
        return this;
    }

    public int getHighlightedRaised() {
        return HIGHLIGHTED_RAISED_AMOUNT.get(this.getMap());
    }

    public TitledTabProperties setEnabled(boolean bl) {
        ENABLED.set(this.getMap(), bl);
        return this;
    }

    public boolean getEnabled() {
        return ENABLED.get(this.getMap());
    }

    public TitledTabProperties setHoverListener(HoverListener hoverListener) {
        HOVER_LISTENER.set(this.getMap(), hoverListener);
        return this;
    }

    public HoverListener getHoverListener() {
        return HOVER_LISTENER.get(this.getMap());
    }

    private static void updateVisualProperties() {
        PropertyMapManager.runBatch(new Runnable(){

            public void run() {
                int n = TabbedUIDefaults.getIconTextGap();
                DEFAULT_VALUES.getNormalProperties().getShapedPanelProperties().setOpaque(true);
                DEFAULT_VALUES.getNormalProperties().setIconTextGap(n).setTextTitleComponentGap(n).setIconVisible(true).setTextVisible(true).setTitleComponentVisible(true).getComponentProperties().setFont(TabbedUIDefaults.getFont()).setForegroundColor(TabbedUIDefaults.getNormalStateForeground()).setBackgroundColor(TabbedUIDefaults.getNormalStateBackground()).setBorder(new TabAreaLineBorder()).setInsets(TabbedUIDefaults.getTabInsets());
                DEFAULT_VALUES.getHighlightedProperties().getComponentProperties().setBackgroundColor(TabbedUIDefaults.getHighlightedStateBackground()).setBorder(new CompoundBorder(new TabAreaLineBorder(), new TabHighlightBorder(TabbedUIDefaults.getHighlight(), true)));
                DEFAULT_VALUES.getDisabledProperties().getComponentProperties().setForegroundColor(TabbedUIDefaults.getDisabledForeground()).setBackgroundColor(TabbedUIDefaults.getDisabledBackground());
            }
        });
    }

    private static void updateFunctionalProperties() {
        DEFAULT_VALUES.setEnabled(true).setFocusable(true).setFocusMarkerEnabled(true).setSizePolicy(TitledTabSizePolicy.EQUAL_SIZE).setBorderSizePolicy(TitledTabBorderSizePolicy.EQUAL_SIZE).setHighlightedRaised(2);
        DEFAULT_VALUES.getNormalProperties().setHorizontalAlignment(Alignment.LEFT).setVerticalAlignment(Alignment.CENTER).setIconTextRelativeAlignment(Alignment.LEFT).setTitleComponentTextRelativeAlignment(Alignment.RIGHT).setDirection(Direction.RIGHT);
    }

    static {
        int n;
        PROPERTIES = new PropertyMapGroup("Titled Tab Properties", "Properties for the TitledTab class.");
        FOCUSABLE = new BooleanProperty((PropertyGroup)PROPERTIES, "Focusable", "Tab focusable", PropertyMapValueHandler.INSTANCE);
        FOCUS_MARKER_ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Focus Marker Enabled", "Enables or disables the focus marker when the tab has focus.", PropertyMapValueHandler.INSTANCE);
        NORMAL_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Normal Properties", "Normal tab properties.", TitledTabStateProperties.PROPERTIES);
        HIGHLIGHTED_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Highlighted Properties", "Highlighted tab properties.", TitledTabStateProperties.PROPERTIES);
        DISABLED_PROPERTIES = new PropertyMapProperty((PropertyGroup)PROPERTIES, "Disabled Properties", "Disabled tab properties.", TitledTabStateProperties.PROPERTIES);
        SIZE_POLICY = new TitledTabSizePolicyProperty((PropertyGroup)PROPERTIES, "Size Policy", "Tab size policy", PropertyMapValueHandler.INSTANCE);
        BORDER_SIZE_POLICY = new TitledTabBorderSizePolicyProperty((PropertyGroup)PROPERTIES, "Border Size Policy", "Border size policy.", PropertyMapValueHandler.INSTANCE);
        MINIMUM_SIZE_PROVIDER = new DimensionProviderProperty((PropertyGroup)PROPERTIES, "Minimum Size", "Tab minimum size.", PropertyMapValueHandler.INSTANCE);
        HIGHLIGHTED_RAISED_AMOUNT = IntegerProperty.createPositive(PROPERTIES, "Highlighted Raised", "Number of raised pixels for highlighted tab.", 2, PropertyMapValueHandler.INSTANCE);
        HOVER_LISTENER = new HoverListenerProperty((PropertyGroup)PROPERTIES, "Hover Listener", "Hover Listener to be used for tracking mouse hovering over the tab.", PropertyMapValueHandler.INSTANCE);
        ENABLED = new BooleanProperty((PropertyGroup)PROPERTIES, "Enabled", "TitledTab enabled or disabled", PropertyMapValueHandler.INSTANCE);
        DEFAULT_VALUES = new TitledTabProperties(PROPERTIES.getDefaultMap());
        DynamicUIManager.getInstance().addListener(new DynamicUIManagerListener(){

            public void lookAndFeelChanged() {
                TitledTabProperties.updateVisualProperties();
            }

            public void propertiesChanged() {
                TitledTabProperties.updateVisualProperties();
            }

            public void propertiesChanging() {
            }

            public void lookAndFeelChanging() {
            }
        });
        DEFAULT_VALUES.getNormalProperties().getMap().createRelativeRef(TitledTabStateProperties.TOOL_TIP_TEXT, DEFAULT_VALUES.getNormalProperties().getMap(), TitledTabStateProperties.TEXT);
        DEFAULT_VALUES.getHighlightedProperties().getMap().addSuperMap(DEFAULT_VALUES.getNormalProperties().getMap());
        DEFAULT_VALUES.getDisabledProperties().getMap().addSuperMap(DEFAULT_VALUES.getNormalProperties().getMap());
        Property[] propertyArray = TitledTabStateProperties.PROPERTIES.getProperties();
        for (n = 0; n < propertyArray.length; ++n) {
            DEFAULT_VALUES.getHighlightedProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getMap(), propertyArray[n]);
            DEFAULT_VALUES.getDisabledProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getMap(), propertyArray[n]);
        }
        propertyArray = ComponentProperties.PROPERTIES.getProperties();
        for (n = 0; n < propertyArray.length; ++n) {
            DEFAULT_VALUES.getHighlightedProperties().getComponentProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getComponentProperties().getMap(), propertyArray[n]);
            DEFAULT_VALUES.getDisabledProperties().getComponentProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getComponentProperties().getMap(), propertyArray[n]);
        }
        propertyArray = ShapedPanelProperties.PROPERTIES.getProperties();
        for (n = 0; n < propertyArray.length; ++n) {
            DEFAULT_VALUES.getHighlightedProperties().getShapedPanelProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getShapedPanelProperties().getMap(), propertyArray[n]);
            DEFAULT_VALUES.getDisabledProperties().getShapedPanelProperties().getMap().createRelativeRef(propertyArray[n], DEFAULT_VALUES.getNormalProperties().getShapedPanelProperties().getMap(), propertyArray[n]);
        }
        TitledTabProperties.updateVisualProperties();
        TitledTabProperties.updateFunctionalProperties();
    }
}

