% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ARE_cbe.R
\name{ARE_cbe}
\alias{ARE_cbe}
\title{ARE method for composite binary endpoints}
\usage{
ARE_cbe(
  p0_e1,
  p0_e2,
  eff_e1,
  effm_e1 = "or",
  eff_e2,
  effm_e2 = "or",
  effm_ce = "or",
  rho
)
}
\arguments{
\item{p0_e1}{numeric parameter, probability of occurrence E1 in the control group}

\item{p0_e2}{numeric parameter, probability of occurrence E2 in the control group}

\item{eff_e1}{numeric parameter, anticipated effect for the composite component E1}

\item{effm_e1}{Effect measure used for the event E1  (effm_e1 = "diff" for difference of proportions, effm_e1 = "rr" for risk ratio, effm_e1 = "or" for odds ratio)}

\item{eff_e2}{numeric parameter, anticipated effect for the composite component E2}

\item{effm_e2}{Effect measure used for the event E2  (effm_e2 = "diff" for difference of proportions, effm_e2 = "rr" for risk ratio, effm_e2 = "or" for odds ratio)}

\item{effm_ce}{Effect measure used for the composite endpoint (effm_ce = "diff" for difference of proportions, effm_ce = "rr" for risk ratio, effm_ce = "or" for odds ratio)}

\item{rho}{numeric parameter, Pearson's correlation between the two events E1 and E2}
}
\value{
Returns the ARE value. If the ARE value is larger than 1 then the composite endpoint is preferred over the relevant endpoint. Otherwise, the endpoint 1 is preferred as the primary endpoint of the study.
}
\description{
The composite endpoint is assumed to be a binary endpoint formed by a combination of two events (E1 and E2). We assume that the endpoint 1 is more relevant for the clinical question than endpoint 2. 
This function calculates the ARE method for binary endpoints. The method quantifies the differences in efficiency of using the composite or the relevant as primary endpoint to lead the trial and, moreover, provides a decision rule to choose the primary endpoint. If the ARE is larger than 1, the composite endpoint may be considered the best option as primary endpoint. Otherwise, the relevant endpoint is preferred.
}
\details{
The input parameters stand for the probability of the composite components and Pearson's correlation between the two components.
Note that Pearson's correlation takes values between two bounds that depend on the probabilities p0_e1 and p0_e2.
To calculate the correlation bounds you can use the R functions lower_corr and upper_corr, available in this package.
}
\references{
Bofill Roig, M., & Gomez Melis, G. (2018). Selection of composite binary endpoints in clinical trials. Biometrical Journal, 60(2), 246-261. https://doi.org/10.1002/bimj.201600229
}
