% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lower_corr.R
\name{lower_corr}
\alias{lower_corr}
\title{Lower bound for Pearson's Correlation}
\usage{
lower_corr(p_e1, p_e2)
}
\arguments{
\item{p_e1}{numeric parameter, probability of the event E1}

\item{p_e2}{numeric parameter, probability of the event E2}
}
\value{
Returns the minimum value that the correlation between the two outcomes can take.
}
\description{
Pearson's correlation between two binary outcomes takes values between two bounds defined according to the probabilities of the binary outcomes.
This function calculates the lower bound of the correlation based on the probabilities of two binary outcomes.
}
\details{
lower_corr returns a numeric value between -1 and 0.
}
\examples{
CompAREdesign::lower_corr(p_e1=0.1, p_e2=0.6)

}
