% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simula_cbe.R
\name{simula_cbe}
\alias{simula_cbe}
\title{Simulation of binary composite endpoints}
\usage{
simula_cbe(p0_e1, p0_e2, eff_e1, effm_e1, eff_e2, effm_e2, rho, samplesize)
}
\arguments{
\item{p0_e1}{numeric parameter, probability of occurrence E1 in the control group}

\item{p0_e2}{numeric parameter, probability of occurrence E2 in the control group}

\item{eff_e1}{numeric parameter, anticipated effect for the composite component E1}

\item{effm_e1}{Effect measure used for the event E1  (effm_e1 = "diff" for difference of proportions, effm_e1 = "rr" for risk ratio, effm_e1 = "or" for odds ratio)}

\item{eff_e2}{numeric parameter, anticipated effect for the composite component E2}

\item{effm_e2}{Effect measure used for the event E2  (effm_e2 = "diff" for difference of proportions, effm_e2 = "rr" for risk ratio, effm_e2 = "or" for odds ratio)}

\item{rho}{numeric parameter, Pearson's correlation between the two events E1 and E2}

\item{samplesize}{sample size per arm}
}
\value{
Simulated data
}
\description{
This simulates two-arm randomised controlled trials with binary composite endpoints. The composite endpoint is assumed to be an endpoint formed by a combination of two events (E1 and E2).
}
\details{
The input parameters stand for the probability of the composite components and Pearson's correlation between the two components.
Note that Pearson's correlation takes values between two bounds that depend on the probabilities p0_e1 and p0_e2.
To calculate the correlation bounds you can use the R functions lower_corr and upper_corr, available in this package.
}
