% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/tools.R
\name{predict.compCL}
\alias{predict.compCL}
\title{Make predictions based on a \code{"compCL"} object.}
\usage{
\method{predict}{compCL}(object, Znew, Zcnew = NULL, s = NULL, ...)
}
\arguments{
\item{object}{fitted \code{"\link{compCL}"} object.}

\item{Znew}{\code{z} matrix as in \code{compCL} with new compositional data
or categorical data.}

\item{Zcnew}{\code{Zc} matrix as in \code{compCL} with new data for other
covariates. Default is \code{NULL}}

\item{s}{value(s) of the penalty parameter \code{lam} at which predictions are required.
Default is the entire sequence used in the fitted object.}

\item{\dots}{not used.}
}
\value{
predicted values at the requested values of \code{s}.
}
\description{
Make predictions based on a fitted \code{"\link{compCL}"} object.
}
\details{
\code{s} is the vector at which predictions are requested. If \code{s} is not in the lambda
sequence used for fitting the model, the \code{predict} function uses linear interpolation.
}
\examples{
Comp_data = comp_Model(n = 50, p = 30)
Comp_data2 = comp_Model(n = 30, p = 30, beta = Comp_data$beta)
m1 = compCL(y = Comp_data$y, Z = Comp_data$X.comp,
            Zc = Comp_data$Zc, intercept = Comp_data$intercept)
predict(m1, Znew = Comp_data2$X.comp, Zcnew = Comp_data2$Zc)
predict(m1, Znew = Comp_data2$X.comp, Zcnew = Comp_data2$Zc, s = c(1, 0.5, 0.1))

}
\references{
Lin, W., Shi, P., Peng, R. and Li, H. (2014) \emph{Variable selection in
regression with compositional covariates},
\href{https://academic.oup.com/biomet/article/101/4/785/1775476}{https://academic.oup.com/biomet/article/101/4/785/1775476}.
\emph{Biometrika} \strong{101} 785-979.
}
\seealso{
\code{\link{compCL}} and \code{\link[=coef.compCL]{coef}},
\code{\link[=print.compCL]{predict}} and \code{\link[=plot.compCL]{plot}} methods
for \code{"compCL"} object.
}
\author{
Zhe Sun and Kun Chen
}
