% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conData.R
\name{conData}
\alias{conData}
\title{Explore and tidy raw data}
\usage{
conData(data)
}
\arguments{
\item{data}{Binary time-points-by-variable matrix}
}
\value{
A conData-object including:

\code{data}     Binary data in time points to variable format.

\code{probs}    Table of relative frequency and auto-dependence for each variable.

\code{varNames} The names of all variables.
}
\description{
Removes not binary columns from multivariate time series data and calculates a table of relative frequency and auto-dependency for each binary variable
}
\examples{
ExampleData <- cbind(rep(c(0,1),100),
                     rep(c(0,0,0,0,0,1,1,1,1,1),20),
                     c(
                       rep(c(0,0,0,1,1),20),
                       rep(c(0,1,1,1,1),20)
                     ),
                     ifelse(rnorm(200,0,1)<0.95,1,0),
                     c(
                       ifelse(rnorm(100,0,1)<0.7,1,0),
                       ifelse(rnorm(100,0,1)<0.7,0,1)
                     ),
                     ifelse(rnorm(200,0,1)<(-0.98),1,0))
colnames(ExampleData) <- c('Var 1','Var 2','Var 3',
                           'Var 4','Var 5','Var 6')
conData(ExampleData)

data(SymptomData)
Sdata <- conData(SymptomData)
Sdata$probs

}
